/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.common.telemetry.CommonAttributes;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationContext;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapoint;

public final class Operation
extends TelemetryDatapoint {
    @NonNull
    private final String id;
    @NonNull
    private final Optional<Operation> parent;
    @NonNull
    private final OperationContext context;

    Operation(String id, String name, Map<String, Attribute> attributes, OperationContext context, Optional<Operation> parent) {
        this(id, name, attributes, context, parent, true);
    }

    Operation(@NonNull String id, @NonNull String name, @NonNull Map<String, Attribute> attributes, @NonNull OperationContext context, @NonNull Optional<Operation> parent, boolean inferParent) {
        super(name, Operation.addStandardAttributes(attributes));
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.id = id;
        this.context = context;
        this.parent = !parent.isPresent() && inferParent ? this.context.getCurrentNonDefaultOperation() : parent;
    }

    private static Map<String, Attribute> addStandardAttributes(Map<String, Attribute> attributes) {
        Attribute threadIdAttribute = CommonAttributes.threadId(Thread.currentThread());
        attributes.put(threadIdAttribute.getName(), threadIdAttribute);
        return attributes;
    }

    public static OperationBuilder builder() {
        return new OperationBuilder();
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Optional<Operation> getParent() {
        return this.parent;
    }

    @NonNull
    @Generated
    public OperationContext getContext() {
        return this.context;
    }

    @Generated
    public String toString() {
        return "Operation(id=" + this.getId() + ", parent=" + this.getParent() + ", context=" + this.getContext() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Optional<Operation> this$parent = this.getParent();
        Optional<Operation> other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        OperationContext this$context = this.getContext();
        OperationContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Optional<Operation> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        OperationContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public static class OperationBuilder
    extends TelemetryDatapoint.TelemetryDatapointBuilder<Operation, OperationBuilder> {
        private String id;
        private Optional<Operation> parent = Optional.empty();
        private OperationContext context = OperationContext.DEFAULT;
        private static final int ID_GENERATION_RADIX = 32;

        public OperationBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public OperationBuilder parent(@NonNull Operation parent) {
            if (parent == null) {
                throw new NullPointerException("parent is marked non-null but is null");
            }
            this.parent = Optional.of(parent);
            return this;
        }

        public OperationBuilder context(@NonNull OperationContext context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            this.context = context;
            return this;
        }

        @Override
        protected Operation buildCore() {
            if (this.id == null) {
                this.id = this.generateID();
            }
            return new Operation(this.id, this.getName(), this.getAttributes(), this.context, this.parent);
        }

        private String generateID() {
            long random = ThreadLocalRandom.current().nextLong();
            return Long.toString(random, 32);
        }
    }
}

