/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public class ObjectMetadata {
    long contentLength;
    @NonNull
    String etag;

    private ObjectMetadata(long contentLength, @NonNull String etag) {
        if (etag == null) {
            throw new NullPointerException("etag is marked non-null but is null");
        }
        Preconditions.checkArgument(contentLength >= 0L, "content length must be non-negative");
        this.contentLength = contentLength;
        this.etag = etag;
    }

    @Generated
    public static ObjectMetadataBuilder builder() {
        return new ObjectMetadataBuilder();
    }

    @Generated
    public long getContentLength() {
        return this.contentLength;
    }

    @NonNull
    @Generated
    public String getEtag() {
        return this.etag;
    }

    @Generated
    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    @Generated
    public void setEtag(@NonNull String etag) {
        if (etag == null) {
            throw new NullPointerException("etag is marked non-null but is null");
        }
        this.etag = etag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectMetadata)) {
            return false;
        }
        ObjectMetadata other = (ObjectMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObjectMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ObjectMetadata(contentLength=" + this.getContentLength() + ", etag=" + this.getEtag() + ")";
    }

    @Generated
    public static class ObjectMetadataBuilder {
        @Generated
        private long contentLength;
        @Generated
        private String etag;

        @Generated
        ObjectMetadataBuilder() {
        }

        @Generated
        public ObjectMetadataBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Generated
        public ObjectMetadataBuilder etag(@NonNull String etag) {
            if (etag == null) {
                throw new NullPointerException("etag is marked non-null but is null");
            }
            this.etag = etag;
            return this;
        }

        @Generated
        public ObjectMetadata build() {
            return new ObjectMetadata(this.contentLength, this.etag);
        }

        @Generated
        public String toString() {
            return "ObjectMetadata.ObjectMetadataBuilder(contentLength=" + this.contentLength + ", etag=" + this.etag + ")";
        }
    }
}

