/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.ri.AbstractUnit;

public final class AlternateUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private final AbstractUnit<?> parentUnit;
    private final String symbol;

    public AlternateUnit(AbstractUnit<?> parentUnit, String symbol) {
        if (!parentUnit.isSystemUnit()) {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not an unscaled SI unit");
        }
        this.parentUnit = parentUnit instanceof AlternateUnit ? ((AlternateUnit)parentUnit).getParentUnit() : parentUnit;
        this.symbol = symbol;
    }

    public AlternateUnit(Unit<?> parentUnit, String symbol) {
        this((AbstractUnit)parentUnit, symbol);
    }

    public AbstractUnit<?> getParentUnit() {
        return this.parentUnit;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return this.parentUnit.getSystemConverter();
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this;
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.parentUnit.getBaseUnits();
    }

    @Override
    public int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlternateUnit)) {
            return false;
        }
        AlternateUnit that = (AlternateUnit)obj;
        return this.parentUnit.equals(that.parentUnit) && this.symbol.equals(that.symbol);
    }
}

