/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell.paragraph;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.cell.ParagraphCellDrawer;
import org.vandeseer.easytable.split.ParagraphCellDataSplitter;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.Hyperlink;
import org.vandeseer.easytable.structure.cell.paragraph.Markup;
import org.vandeseer.easytable.structure.cell.paragraph.NewLine;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphProcessable;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;

public class ParagraphCell
extends AbstractCell {
    protected float lineSpacing;
    private Paragraph paragraph;

    @Override
    public SplitCellData splitCell(float height) {
        return ParagraphCellDataSplitter.builder().cell(this).lineSpacing(this.lineSpacing).availableHeight(height).build().splitContents();
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
        if (!this.getParagraph().getProcessables().isEmpty()) {
            while (this.getParagraph().getWrappedParagraph().removeLast() != null) {
            }
        }
        this.getParagraph().getProcessables().forEach(processable -> processable.process(this.getParagraph().getWrappedParagraph(), this.getSettings()));
        rst.pdfbox.layout.elements.Paragraph wrappedParagraph = this.paragraph.getWrappedParagraph();
        wrappedParagraph.setLineSpacing(this.getLineSpacing());
        wrappedParagraph.setApplyLineSpacingToFirstLine(false);
        wrappedParagraph.setMaxWidth(width - this.getHorizontalPadding());
    }

    @Override
    protected Drawer createDefaultDrawer() {
        return new ParagraphCellDrawer(this);
    }

    @Override
    public float getMinHeight() {
        float height = this.paragraph.getWrappedParagraph().getHeight() + this.getVerticalPadding();
        return height > super.getMinHeight() ? height : super.getMinHeight();
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    protected ParagraphCell(ParagraphCellBuilder<?, ?> b) {
        super(b);
        this.lineSpacing = ((ParagraphCellBuilder)b).lineSpacing$set ? ((ParagraphCellBuilder)b).lineSpacing$value : ParagraphCell.$default$lineSpacing();
        this.paragraph = ((ParagraphCellBuilder)b).paragraph;
    }

    public static ParagraphCellBuilder<?, ?> builder() {
        return new ParagraphCellBuilderImpl();
    }

    public ParagraphCellBuilder<?, ?> toBuilder() {
        return new ParagraphCellBuilderImpl().$fillValuesFrom(this);
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public Paragraph getParagraph() {
        return this.paragraph;
    }

    private static final class ParagraphCellBuilderImpl
    extends ParagraphCellBuilder<ParagraphCell, ParagraphCellBuilderImpl> {
        private ParagraphCellBuilderImpl() {
        }

        @Override
        protected ParagraphCellBuilderImpl self() {
            return this;
        }

        @Override
        public ParagraphCell build() {
            return new ParagraphCell(this);
        }
    }

    public static abstract class ParagraphCellBuilder<C extends ParagraphCell, B extends ParagraphCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private boolean lineSpacing$set;
        private float lineSpacing$value;
        private Paragraph paragraph;

        public B font(PDFont font) {
            this.settings.setFont(font);
            return (B)this.self();
        }

        public B fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return (B)this.self();
        }

        public B textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ParagraphCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ParagraphCell instance, ParagraphCellBuilder<?, ?> b) {
            b.lineSpacing(instance.lineSpacing);
            b.paragraph(instance.paragraph);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B lineSpacing(float lineSpacing) {
            this.lineSpacing$value = lineSpacing;
            this.lineSpacing$set = true;
            return (B)this.self();
        }

        public B paragraph(Paragraph paragraph) {
            this.paragraph = paragraph;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ParagraphCell.ParagraphCellBuilder(super=" + super.toString() + ", lineSpacing$value=" + this.lineSpacing$value + ", paragraph=" + this.paragraph + ")";
        }
    }

    public static class Paragraph {
        private final List<ParagraphProcessable> processables;
        private rst.pdfbox.layout.elements.Paragraph wrappedParagraph = new rst.pdfbox.layout.elements.Paragraph();

        public Paragraph(List<ParagraphProcessable> processables) {
            this.processables = processables;
        }

        public static ParagraphBuilder builder() {
            return new ParagraphBuilder();
        }

        List<ParagraphProcessable> getProcessables() {
            return this.processables;
        }

        public rst.pdfbox.layout.elements.Paragraph getWrappedParagraph() {
            return this.wrappedParagraph;
        }

        public void setWrappedParagraph(rst.pdfbox.layout.elements.Paragraph wrappedParagraph) {
            this.wrappedParagraph = wrappedParagraph;
        }

        public static class ParagraphBuilder {
            private List<ParagraphProcessable> processables = new LinkedList<ParagraphProcessable>();

            private ParagraphBuilder() {
            }

            public ParagraphBuilder append(StyledText styledText) {
                this.processables.add(styledText);
                return this;
            }

            public ParagraphBuilder append(Hyperlink hyperlink) {
                this.processables.add(hyperlink);
                return this;
            }

            public ParagraphBuilder append(Markup markup) {
                this.processables.add(markup);
                return this;
            }

            public ParagraphBuilder appendNewLine() {
                this.processables.add(new NewLine());
                return this;
            }

            public ParagraphBuilder appendNewLine(float fontSize) {
                this.processables.add(new NewLine(fontSize));
                return this;
            }

            public Paragraph build() {
                return new Paragraph(this.processables);
            }
        }
    }
}

