/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.shape.Stroke;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.WidthRespecting;

public class HorizontalRuler
implements Drawable,
Element,
WidthRespecting {
    private Stroke stroke;
    private Color color;
    private float maxWidth = -1.0f;

    public HorizontalRuler(Stroke stroke, Color color) {
        this.stroke = stroke;
        this.color = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public float getWidth() throws IOException {
        return this.getMaxWidth();
    }

    @Override
    public float getHeight() throws IOException {
        if (this.getStroke() == null) {
            return 0.0f;
        }
        return this.getStroke().getLineWidth();
    }

    @Override
    public Position getAbsolutePosition() {
        return null;
    }

    @Override
    public void draw(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, DrawListener drawListener) throws IOException {
        if (this.getColor() != null) {
            contentStream.setStrokingColor(this.getColor());
        }
        if (this.getStroke() != null) {
            this.getStroke().applyTo(contentStream);
            float x = upperLeft.getX();
            float y = upperLeft.getY() - this.getStroke().getLineWidth() / 2.0f;
            contentStream.addLine(x, y, x + this.getWidth(), y);
            contentStream.stroke();
        }
        if (drawListener != null) {
            drawListener.drawn(this, upperLeft, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Drawable removeLeadingEmptyVerticalSpace() {
        return this;
    }
}

