/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.drawing.cell;

import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import org.vandeseer.easytable.drawing.cell.TextCellDrawer;
import org.vandeseer.easytable.structure.cell.AbstractTextCell;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;

public class TextFileLinkCellDrawer<T extends TextFileLinkCell>
extends TextCellDrawer<TextFileLinkCell> {
    protected List<FileAnnotation> annotations;
    protected float pinWidth;
    protected float pinHeight;
    protected float leftGapPin;
    protected float rightGapPin;

    public TextFileLinkCellDrawer(T cell) {
        this.cell = cell;
        this.annotations = ((TextFileLinkCell)cell).getAnnotations();
        this.pinWidth = ((TextFileLinkCell)cell).getPinWidth();
        this.pinHeight = ((TextFileLinkCell)cell).getPinHeight();
        this.leftGapPin = ((TextFileLinkCell)cell).getLeftGapPin();
        this.rightGapPin = ((TextFileLinkCell)cell).getRightGapPin();
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        PDFont currentFont = ((AbstractTextCell)this.cell).getFont();
        int currentFontSize = ((AbstractTextCell)this.cell).getFontSize();
        float yOffset = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment();
        float xOffset = drawingContext.getStartingPoint().x + ((AbstractTextCell)this.cell).getPaddingLeft();
        yOffset -= this.calculateYOffset(currentFont, currentFontSize, 0);
        for (FileAnnotation fileAnnot : this.annotations) {
            this.updateAnnotation(fileAnnot, drawingContext, xOffset, yOffset);
            this.drawText(drawingContext, PositionedStyledText.builder().x(xOffset += this.pinWidth + this.leftGapPin).y(yOffset).text(fileAnnot.getText()).font(currentFont).fontSize(currentFontSize).color(((AbstractTextCell)this.cell).getTextColor()).build());
            xOffset += PdfUtil.getStringWidth(fileAnnot.getText(), currentFont, currentFontSize) + this.rightGapPin;
        }
    }

    private void updateAnnotation(FileAnnotation annotation, DrawingContext drawingContext, float x, float y) {
        PDRectangle rectangle = new PDRectangle(x, y, this.pinWidth, this.pinHeight);
        annotation.setRectangle(rectangle);
        annotation.setPage(drawingContext.getPage());
    }

    public TextFileLinkCellDrawer() {
    }
}

