/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.vue.core.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.client.common.domain.ClientsModulesFactory;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;

public class VueModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/vue");
    private static final JHipsterSource IMAGE_SOURCE = SOURCE.append("webapp/content/images");
    private static final JHipsterSource COMMON_PRIMARY_SOURCE = SOURCE.append("webapp/app/common/primary");
    private static final JHipsterSource COMMON_PRIMARY_TEST_SOURCE = SOURCE.append("test/spec/common/primary");
    private static final JHipsterDestination MAIN_DESTINATION = JHipsterModule.to("src/main/webapp/app");
    private static final JHipsterDestination MAIN_PRIMARY_DESTINATION = MAIN_DESTINATION.append("common/primary");
    private static final JHipsterDestination COMMON_PRIMARY_TEST_DESTINATION = JHipsterModule.to("src/test/javascript/spec/common/primary");
    private static final String IMPORT_NEEDLE = "// jhipster-needle-main-ts-import";
    private static final String PROVIDER_NEEDLE = "// jhipster-needle-main-ts-provider";

    public JHipsterModule buildVueModule(JHipsterModuleProperties properties) {
        return ClientsModulesFactory.clientModuleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("vue"), VersionSource.VUE).addDependency(JHipsterModule.packageName("axios"), VersionSource.VUE).addDependency(JHipsterModule.packageName("vue-router"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@rushstack/eslint-patch"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@types/jest"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@typescript-eslint/parser"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vitejs/plugin-vue"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/eslint-config-typescript"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/eslint-config-prettier"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/test-utils"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("eslint"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("eslint-plugin-vue"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("jest"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("jest-sonar-reporter"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("jest-transform-stub"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("ts-jest"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("typescript"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("vite"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("vue-jest"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("vue-tsc"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@types/sinon"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("sinon"), VersionSource.VUE).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("vue-tsc -p tsconfig.build.json --noEmit && vite build --emptyOutDir")).addScript(JHipsterModule.scriptKey("dev"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("jest"), JHipsterModule.scriptCommand("jest src/test/javascript/spec --logHeapUsage --maxWorkers=2 --no-cache")).addScript(JHipsterModule.scriptKey("preview"), JHipsterModule.scriptCommand("vite preview")).addScript(JHipsterModule.scriptKey("start"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("test"), JHipsterModule.scriptCommand("npm run jest --")).addScript(JHipsterModule.scriptKey("test:watch"), JHipsterModule.scriptCommand("npm run jest -- --watch")).and().files().add(SOURCE.file(".eslintrc.js"), JHipsterModule.to(".eslintrc.js")).add(SOURCE.file("jest.config.js"), JHipsterModule.to("jest.config.js")).add(SOURCE.file("tsconfig.json"), JHipsterModule.to("tsconfig.json")).add(SOURCE.file("tsconfig.build.json"), JHipsterModule.to("tsconfig.build.json")).add(SOURCE.file("vite.config.ts"), JHipsterModule.to("vite.config.ts")).add(SOURCE.template("webapp/app/http/AxiosHttp.ts.mustache"), MAIN_DESTINATION.append("http/AxiosHttp.ts")).batch(SOURCE.file("test/spec/http"), JHipsterModule.to("src/test/javascript/spec/http")).addTemplate("AxiosHttp.spec.ts").addTemplate("AxiosHttpStub.ts").addTemplate("AxiosStub.ts").and().add(SOURCE.template("webapp/index.html"), JHipsterModule.to("src/main/webapp/index.html")).batch(SOURCE.append("webapp/app"), MAIN_DESTINATION).addTemplate("env.d.ts").addTemplate("main.ts").and().batch(COMMON_PRIMARY_SOURCE.append("app"), MAIN_PRIMARY_DESTINATION.append("app")).addTemplate("App.component.ts").addTemplate("App.html").addTemplate("App.vue").addTemplate("index.ts").and().batch(IMAGE_SOURCE, JHipsterModule.to("src/main/webapp/content/images")).addFile("JHipster-Lite-neon-green.png").addFile("VueLogo.png").and().add(COMMON_PRIMARY_TEST_SOURCE.template("app/App.spec.ts"), COMMON_PRIMARY_TEST_DESTINATION.append("app/App.spec.ts")).batch(COMMON_PRIMARY_SOURCE.append("homepage"), MAIN_PRIMARY_DESTINATION.append("homepage")).addTemplate("Homepage.component.ts").addTemplate("Homepage.html").addTemplate("Homepage.vue").addTemplate("index.ts").and().add(COMMON_PRIMARY_TEST_SOURCE.template("homepage/Homepage.spec.ts"), COMMON_PRIMARY_TEST_DESTINATION.append("homepage/Homepage.spec.ts")).add(SOURCE.template("webapp/app/router/router.ts"), MAIN_DESTINATION.append("router/router.ts")).add(SOURCE.template("test/spec/router/Router.spec.ts"), JHipsterModule.to("src/test/javascript/spec/router/Router.spec.ts")).batch(SOURCE.append("webapp/app/common/domain"), MAIN_DESTINATION.append("common/domain")).addTemplate("Logger.ts").addTemplate("Message.ts").and().add(SOURCE.template("webapp/app/common/secondary/ConsoleLogger.ts"), MAIN_DESTINATION.append("common/secondary/ConsoleLogger.ts")).add(SOURCE.template("test/spec/common/domain/Logger.fixture.ts"), JHipsterModule.to("src/test/javascript/spec/common/domain/Logger.fixture.ts")).add(SOURCE.template("test/spec/common/secondary/ConsoleLogger.spec.ts"), JHipsterModule.to("src/test/javascript/spec/common/secondary/ConsoleLogger.spec.ts")).and().build();
    }

    public JHipsterModule buildPiniaModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("pinia"), VersionSource.VUE).addDependency(JHipsterModule.packageName("pinia-plugin-persist"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@pinia/testing"), VersionSource.VUE).and().mandatoryReplacements().in("src/main/webapp/app/main.ts").add(JHipsterModule.lineBeforeText(IMPORT_NEEDLE), this.piniaImports())).add(JHipsterModule.lineBeforeText(PROVIDER_NEEDLE), this.piniaProvider())).and()).and().build();
    }

    private String piniaImports() {
        return "import { createPinia } from 'pinia';\nimport piniaPersist from 'pinia-plugin-persist';\n";
    }

    private String piniaProvider() {
        return "const pinia = createPinia();\npinia.use(piniaPersist);\napp.use(pinia);\n";
    }
}

