/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.cucumber.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class CucumberModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/cucumber");
    private static final String CUCUMBER_GROUP_ID = "io.cucumber";
    private static final String CUCUMBER_VERSION = "cucumber.version";

    public JHipsterModule buildInitializationModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String applicationName = properties.projectBaseName().capitalized();
        JHipsterDestination destination = JHipsterModule.toSrcTestJava().append(properties.packagePath()).append("cucumber");
        JHipsterModule.JHipsterModuleBuilder builder = JHipsterModule.moduleBuilder(properties).context().put("applicationName", applicationName).and().documentation(JHipsterModule.documentationTitle("Cucumber"), SOURCE.template("cucumber.md")).files().batch(SOURCE, destination).addTemplate("AsyncElementAsserter.java").addTemplate("AsyncHeaderAsserter.java").addTemplate("AsyncResponseAsserter.java").addTemplate("Awaiter.java").addTemplate("CucumberAssertions.java").addTemplate("CucumberRestTemplate.java").addTemplate("CucumberConfiguration.java").addTemplate("CucumberJson.java").addTemplate("CucumberTest.java").addTemplate("CucumberTestContext.java").addTemplate("CucumberTestContextUnitTest.java").addTemplate("ElementAsserter.java").addTemplate("ElementAssertions.java").addTemplate("HeaderAsserter.java").addTemplate("HeaderAssertions.java").addTemplate("ResponseAsserter.java").addTemplate("SyncElementAsserter.java").addTemplate("SyncHeaderAsserter.java").addTemplate("SyncResponseAsserter.java").and().add(SOURCE.file("gitkeep"), JHipsterModule.to("src/test/features/.gitkeep")).and().javaDependencies().addDependency(this.cucumberJunitDependency()).addDependency(this.cucumberJavaDependency()).addDependency(this.cucumberSpringDependency()).addDependency(this.junitVintageDependency()).addDependency(this.testNgDependency()).addDependency(this.awaitilityDependency()).and();
        return builder.build();
    }

    private JavaDependency cucumberJunitDependency() {
        return JHipsterModule.javaDependency().groupId(CUCUMBER_GROUP_ID).artifactId("cucumber-junit").versionSlug(CUCUMBER_VERSION).scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency cucumberJavaDependency() {
        return JHipsterModule.javaDependency().groupId(CUCUMBER_GROUP_ID).artifactId("cucumber-java").versionSlug(CUCUMBER_VERSION).scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency cucumberSpringDependency() {
        return JHipsterModule.javaDependency().groupId(CUCUMBER_GROUP_ID).artifactId("cucumber-spring").versionSlug(CUCUMBER_VERSION).scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency junitVintageDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.vintage").artifactId("junit-vintage-engine").scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency testNgDependency() {
        return JHipsterModule.javaDependency().groupId("org.testng").artifactId("testng").versionSlug("testng.version").scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency awaitilityDependency() {
        return JHipsterModule.javaDependency().groupId("org.awaitility").artifactId("awaitility").scope(JavaDependencyScope.TEST).build();
    }

    public JHipsterModule buildJpaResetModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).files().add(SOURCE.template("CucumberJpaReset.java"), JHipsterModule.toSrcTestJava().append(properties.packagePath()).append("cucumber").append("CucumberJpaReset.java")).and().build();
    }
}

