/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.customjhlite.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;

public class CustomJHLiteModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/custom-jhlite/");
    private static final PropertyKey EXCEPTION_PACKAGE_KEY = JHipsterModule.propertyKey("application.exception.package");
    private static final PropertyKey SERVER_PORT_KEY = JHipsterModule.propertyKey("server.port");
    private static final PropertyKey JACKSON_INCLUSION_KEY = JHipsterModule.propertyKey("spring.jackson.default-property-inclusion");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Module creation"), SOURCE.template("module-creation.md")).javaDependencies().addDependency(this.jhipsterLiteDependency()).and().mandatoryReplacements().in(this.mainClassFile(properties)).add(JHipsterModule.text("@SpringBootApplication"), this.springBootApplicationWithJHLite(properties))).add(JHipsterModule.lineBeforeText("import org.springframework.boot.SpringApplication;"), "import tech.jhipster.lite.JHLiteApp;")).and()).and().springMainProperties().set(EXCEPTION_PACKAGE_KEY, this.exceptionPackages(properties)).set(SERVER_PORT_KEY, JHipsterModule.propertyValue(properties.serverPort().stringValue())).set(JACKSON_INCLUSION_KEY, JHipsterModule.propertyValue("non_null")).and().springTestProperties().set(SERVER_PORT_KEY, JHipsterModule.propertyValue("0")).and().build();
    }

    private JavaDependency jhipsterLiteDependency() {
        return JHipsterModule.javaDependency().groupId("tech.jhipster.lite").artifactId("jhlite").versionSlug("jhlite").build();
    }

    private String springBootApplicationWithJHLite(JHipsterModuleProperties properties) {
        return "@SpringBootApplication(scanBasePackageClasses = { JHLiteApp.class, " + this.mainClassName(properties) + ".class })";
    }

    private String mainClassFile(JHipsterModuleProperties properties) {
        return "src/main/java/" + properties.packagePath() + "/" + this.mainClassName(properties) + ".java";
    }

    private String mainClassName(JHipsterModuleProperties properties) {
        return properties.projectBaseName().capitalized() + "App";
    }

    private PropertyValue exceptionPackages(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("org.", "java.", "net.", "javax.", "com.", "io.", "de.", "tech.jhipster.lite", properties.basePackage().get());
    }
}

