/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.mongodb.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class MongoDbModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/database/mongodb");
    private static final String MONGO_SECONDARY = "technical/infrastructure/secondary/mongodb";
    public static final String DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/mongodb.yml up -d";
    private final DockerImages dockerImages;

    public MongoDbModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Mongo DB"), SOURCE.template("mongodb.md")).startupCommand(this.startupCommand()).context().put("mongodbDockerImage", this.dockerImages.get("mongo").fullName()).and().javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-data-mongodb")).addDependency(JHipsterModule.groupId("org.mongodb"), JHipsterModule.artifactId("mongodb-driver-sync")).addDependency(this.testContainerDependency()).and().files().add(SOURCE.template("mongodb.yml"), JHipsterModule.toSrcMainDocker().append("mongodb.yml")).batch(SOURCE, JHipsterModule.toSrcMainJava().append(packagePath).append(MONGO_SECONDARY)).addTemplate("MongodbDatabaseConfiguration.java").addTemplate("JSR310DateConverters.java").and().add(SOURCE.template("JSR310DateConvertersTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(MONGO_SECONDARY).append("JSR310DateConvertersTest.java")).add(SOURCE.template("TestMongoDBManager.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestMongoDBManager.java")).add(SOURCE.template("spring.factories"), JHipsterModule.to("src/test/resources/META-INF/spring.factories")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.data.mongodb.database"), JHipsterModule.propertyValue(properties.basePackage().get())).set(JHipsterModule.propertyKey("spring.data.mongodb.uri"), JHipsterModule.propertyValue("mongodb://localhost:27017")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.data.mongodb.uri"), JHipsterModule.propertyValue("${TEST_MONGODB_URI}")).and().springMainLogger("org.reflections", LogLevel.WARN).springMainLogger("org.mongodb.driver", LogLevel.WARN).springTestLogger("org.reflections", LogLevel.WARN).springTestLogger("org.mongodb.driver", LogLevel.WARN).springTestLogger("com.github.dockerjava", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN).build();
    }

    private String startupCommand() {
        return DOCKER_COMPOSE_COMMAND;
    }

    private JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId("mongodb").versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }
}

