/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.nio.charset.StandardCharsets;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.ProjectFilesReader;
import tech.jhipster.lite.module.domain.file.ArgumentsReplacer;
import tech.jhipster.lite.module.domain.file.JHipsterSource;

class JHipsterFileContent {
    private final JHipsterSource source;

    JHipsterFileContent(JHipsterSource source) {
        Assert.notNull("source", source);
        this.source = source;
    }

    public byte[] read(ProjectFilesReader files, JHipsterModuleContext context) {
        Assert.notNull("files", files);
        Assert.notNull("context", context);
        if (this.source.isNotTemplate()) {
            return files.readBytes(this.source.get().toString());
        }
        String rawContent = files.readString(this.source.get().toString());
        return ArgumentsReplacer.replaceArguments(rawContent, context.get()).getBytes(StandardCharsets.UTF_8);
    }
}

