/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.packagejson;

import java.util.ArrayList;
import java.util.Collection;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependencies;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependency;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.Script;
import tech.jhipster.lite.module.domain.packagejson.ScriptCommand;
import tech.jhipster.lite.module.domain.packagejson.ScriptKey;
import tech.jhipster.lite.module.domain.packagejson.Scripts;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;

public class JHipsterModulePackageJson {
    private final Scripts scripts;
    private final PackageJsonDependencies dependencies;
    private final PackageJsonDependencies devDependencies;

    private JHipsterModulePackageJson(JHipsterModulePackageJsonBuilder builder) {
        this.scripts = new Scripts(builder.scripts);
        this.dependencies = new PackageJsonDependencies(builder.dependencies);
        this.devDependencies = new PackageJsonDependencies(builder.devDependencies);
    }

    public static JHipsterModulePackageJsonBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModulePackageJsonBuilder(module);
    }

    public boolean isEmpty() {
        return this.scripts.isEmpty() && this.dependencies.isEmpty() && this.devDependencies.isEmpty();
    }

    public Scripts scripts() {
        return this.scripts;
    }

    public PackageJsonDependencies devDependencies() {
        return this.devDependencies;
    }

    public PackageJsonDependencies dependencies() {
        return this.dependencies;
    }

    public static class JHipsterModulePackageJsonBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<Script> scripts = new ArrayList<Script>();
        private final Collection<PackageJsonDependency> dependencies = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageJsonDependency> devDependencies = new ArrayList<PackageJsonDependency>();

        private JHipsterModulePackageJsonBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModulePackageJsonBuilder addScript(ScriptKey key, ScriptCommand command) {
            this.scripts.add(new Script(key, command));
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDependency(PackageName packageName, VersionSource versionSource) {
            this.dependencies.add(new PackageJsonDependency(packageName, versionSource));
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDevDependency(PackageName packageName, VersionSource versionSource) {
            this.devDependencies.add(new PackageJsonDependency(packageName, versionSource));
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModulePackageJson build() {
            return new JHipsterModulePackageJson(this);
        }
    }
}

