/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleReplacements;
import tech.jhipster.lite.module.domain.replacement.MandatoryReplacementException;
import tech.jhipster.lite.module.domain.replacement.UnknownCurrentValueException;

public class JHipsterModuleMandatoryReplacements
extends JHipsterModuleReplacements {
    private JHipsterModuleMandatoryReplacements(JHipsterModuleMandatoryReplacementsBuilder builder) {
        super(builder);
    }

    public static JHipsterModuleMandatoryReplacementsBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleMandatoryReplacementsBuilder(module);
    }

    public static class JHipsterModuleMandatoryReplacementsBuilder
    extends JHipsterModuleReplacements.JHipsterModuleReplacementsBuilder<JHipsterModuleMandatoryReplacements, JHipsterModuleFileMandatoryReplacementsBuilder> {
        private JHipsterModuleMandatoryReplacementsBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            super(module);
        }

        @Override
        public JHipsterModuleFileMandatoryReplacementsBuilder in(String file) {
            return new JHipsterModuleFileMandatoryReplacementsBuilder(this, file);
        }

        @Override
        public JHipsterModuleMandatoryReplacements build() {
            return new JHipsterModuleMandatoryReplacements(this);
        }
    }

    private record MandatoryReplacer(ElementReplacer replacer, String updatedValue) {
        public MandatoryReplacer {
            Assert.notNull("replacer", replacer);
            Assert.notNull("updatedValue", updatedValue);
        }

        public String apply(String content) {
            if (this.replacer.dontNeedReplacement(content, this.updatedValue())) {
                return content;
            }
            if (this.replacer().notMatchIn(content)) {
                throw new UnknownCurrentValueException(this.replacer().searchMatcher(), content);
            }
            return this.replacer().replacement().apply(content, this.updatedValue());
        }
    }

    private record MandatoryFileReplacer(String file, MandatoryReplacer replacement) implements ContentReplacer
    {
        public MandatoryFileReplacer {
            Assert.notNull("file", file);
            Assert.notNull("replacement", replacement);
        }

        @Override
        public String apply(String content) {
            return this.replacement().apply(content);
        }

        @Override
        public void handleError(Throwable e) {
            throw new MandatoryReplacementException(e);
        }
    }

    public static class JHipsterModuleFileMandatoryReplacementsBuilder
    extends JHipsterModuleReplacements.JHipsterModuleFileReplacementsBuilder<JHipsterModuleMandatoryReplacementsBuilder, JHipsterModuleFileMandatoryReplacementsBuilder> {
        private JHipsterModuleFileMandatoryReplacementsBuilder(JHipsterModuleMandatoryReplacementsBuilder replacements, String file) {
            super(replacements, file);
        }

        @Override
        protected ContentReplacer buildReplacer(String file, ElementReplacer toReplace, String replacement) {
            return new MandatoryFileReplacer(file, new MandatoryReplacer(toReplace, replacement));
        }
    }
}

