/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;
import tech.jhipster.lite.module.infrastructure.primary.JHipsterModulePropertiesDefinitionController;

@Component
class JHipsterModulesPropertiesDefinitionHandlerMapping
extends AbstractUrlHandlerMapping {
    private final Map<String, JHipsterModulePropertiesDefinitionController> controllers;

    public JHipsterModulesPropertiesDefinitionHandlerMapping(ObjectMapper json, JHipsterModulesResources modulesResources) {
        this.controllers = this.buildControllers(json, modulesResources);
    }

    private Map<String, JHipsterModulePropertiesDefinitionController> buildControllers(ObjectMapper json, JHipsterModulesResources modulesResources) {
        return modulesResources.stream().collect(Collectors.toUnmodifiableMap(this.toModuleUrl(), this.toPropertiesDefinitionController(json)));
    }

    private Function<JHipsterModuleResource, String> toModuleUrl() {
        return JHipsterModuleResource::moduleUrl;
    }

    private Function<JHipsterModuleResource, JHipsterModulePropertiesDefinitionController> toPropertiesDefinitionController(ObjectMapper json) {
        return moduleResource -> new JHipsterModulePropertiesDefinitionController(json, (JHipsterModuleResource)moduleResource);
    }

    protected void initApplicationContext() throws BeansException {
        this.setOrder(1);
        super.initApplicationContext();
        this.registerHandlers();
    }

    private void registerHandlers() {
        this.controllers.forEach((x$0, x$1) -> this.registerHandler((String)x$0, x$1));
    }
}

