/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.ProjectFilesReader;

@Service
class FileSystemProjectFilesReader
implements ProjectFilesReader {
    private static final String SLASH = "/";

    FileSystemProjectFilesReader() {
    }

    @Override
    @Generated(reason="The error handling is an hard to test implementation detail")
    public String readString(String path) {
        String string;
        block8: {
            Assert.notBlank("path", path);
            InputStream input = this.getInputStream(path);
            try {
                this.assertFileExist(path, input);
                string = FileSystemProjectFilesReader.toString(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GeneratorException("Error closing " + path + ": " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return string;
    }

    @Generated(reason="The error handling is an hard to test implementation detail")
    private static String toString(InputStream input) {
        try {
            return IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new GeneratorException("Error reading file: " + e.getMessage(), e);
        }
    }

    @Override
    @Generated(reason="The error handling is an hard to test implementation detail")
    public byte[] readBytes(String path) {
        byte[] byArray;
        block8: {
            Assert.notBlank("path", path);
            InputStream input = this.getInputStream(path);
            try {
                this.assertFileExist(path, input);
                byArray = FileSystemProjectFilesReader.toByteArray(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GeneratorException("Error closing " + path + ": " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return byArray;
    }

    private void assertFileExist(String path, InputStream input) {
        if (input == null) {
            throw new GeneratorException("Can't find file: " + path);
        }
    }

    private InputStream getInputStream(String path) {
        return FileSystemProjectFilesReader.class.getResourceAsStream(path.replace("\\", SLASH));
    }

    @Generated(reason="The error handling is an hard to test implementation detail")
    private static byte[] toByteArray(InputStream input) {
        try {
            return IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException e) {
            throw new GeneratorException("Error reading file: " + e.getMessage(), e);
        }
    }
}

