/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleReplacements;

class FileSystemReplacer {
    FileSystemReplacer() {
    }

    public void handle(JHipsterProjectFolder projectFolder, JHipsterModuleReplacements replacements) {
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("replacements", replacements);
        replacements.replacements().forEach(this.applyReplacement(projectFolder));
    }

    private Consumer<ContentReplacer> applyReplacement(JHipsterProjectFolder projectFolder) {
        return replacement -> {
            Path filePath = projectFolder.filePath(replacement.file());
            try {
                String content = Files.readString(filePath);
                String updatedContent = replacement.apply(content);
                Files.writeString(filePath, (CharSequence)updatedContent.replace("\r\n", "\n"), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                replacement.handleError(e);
            }
        };
    }
}

