/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.util.Collection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleTag;

@ConfigurationProperties(value="jhlite-hidden-resources")
class JHipsterHiddenResourcesProperties {
    private Collection<String> slugs;
    private Collection<JHipsterModuleTag> tags;

    JHipsterHiddenResourcesProperties() {
    }

    public void setSlugs(Collection<String> slugs) {
        this.slugs = slugs;
    }

    public void setTags(Collection<String> tags) {
        this.tags = tags == null ? null : tags.stream().map(JHipsterModuleTag::new).toList();
    }

    public boolean allowed(JHipsterModuleResource resource) {
        return this.notExcludedSlug(resource) && this.noExcludedTag(resource);
    }

    private boolean notExcludedSlug(JHipsterModuleResource resource) {
        if (this.slugs == null) {
            return true;
        }
        return !this.slugs.contains(resource.slug().get());
    }

    private boolean noExcludedTag(JHipsterModuleResource resource) {
        if (this.tags == null) {
            return true;
        }
        return this.tags.stream().noneMatch(tag -> resource.tags().contains((JHipsterModuleTag)tag));
    }
}

