/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;

class PropertiesFileSpringPropertiesHandler {
    private static final String EQUAL = "=";
    private static final String COLLECTION_SEPARATOR = ",";
    private final Path file;

    public PropertiesFileSpringPropertiesHandler(Path file) {
        Assert.notNull("file", file);
        this.file = file;
    }

    public void set(PropertyKey key, PropertyValue value) {
        Assert.notNull("key", key);
        Assert.notNull("value", value);
        this.updateProperties(key, value);
    }

    @Generated
    private void updateProperties(PropertyKey key, PropertyValue value) {
        try {
            String properties = this.buildProperties(key, value);
            Files.write(this.file, properties.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GeneratorException("Error updating properties: " + e.getMessage(), e);
        }
    }

    private String buildProperties(PropertyKey key, PropertyValue value) throws IOException {
        String currentProperties = this.readOrInitProperties();
        int propertyIndex = currentProperties.indexOf(this.propertyId(key));
        if (propertyIndex != -1) {
            String start = currentProperties.substring(0, propertyIndex);
            String end = currentProperties.substring(currentProperties.indexOf("\n", propertyIndex));
            return start + this.propertyLine(key, value) + end;
        }
        return currentProperties + this.propertyLine(key, value);
    }

    private String readOrInitProperties() throws IOException {
        if (Files.notExists(this.file, new LinkOption[0])) {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            Files.createFile(this.file, new FileAttribute[0]);
            return "";
        }
        return Files.readString(this.file) + "\n";
    }

    private String propertyLine(PropertyKey key, PropertyValue value) {
        return this.propertyId(key) + value.get().stream().collect(Collectors.joining(COLLECTION_SEPARATOR));
    }

    private String propertyId(PropertyKey key) {
        return key.get() + EQUAL;
    }
}

