/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.statistic.infrastructure.secondary;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.statistic.domain.AppliedModule;
import tech.jhipster.lite.statistic.domain.Statistics;
import tech.jhipster.lite.statistic.domain.StatisticsRepository;
import tech.jhipster.lite.statistic.infrastructure.secondary.WithoutMongoDB;

@Repository
@WithoutMongoDB
class InMemoryStatisticsRepository
implements StatisticsRepository {
    private final Collection<AppliedModule> appliedModules = Collections.newSetFromMap(new ConcurrentHashMap());

    InMemoryStatisticsRepository() {
    }

    @Override
    public void save(AppliedModule moduleApplied) {
        Assert.notNull("moduleApplied", moduleApplied);
        this.appliedModules.add(moduleApplied);
    }

    @Override
    public Statistics get() {
        return new Statistics(this.appliedModules.size());
    }

    void clear() {
        this.appliedModules.clear();
    }
}

