/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.technical.infrastructure.primary.cors;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
class CorsFilterConfiguration {
    private final Logger log = LoggerFactory.getLogger(CorsFilterConfiguration.class);
    private final CorsConfiguration corsConfiguration;

    public CorsFilterConfiguration(CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (!CollectionUtils.isEmpty((Collection)this.corsConfiguration.getAllowedOrigins()) || !CollectionUtils.isEmpty((Collection)this.corsConfiguration.getAllowedOriginPatterns())) {
            this.log.debug("Registering CORS filter");
            source.registerCorsConfiguration("/api/**", this.corsConfiguration);
            source.registerCorsConfiguration("/management/**", this.corsConfiguration);
            source.registerCorsConfiguration("/v2/api-docs", this.corsConfiguration);
            source.registerCorsConfiguration("/v3/api-docs", this.corsConfiguration);
            source.registerCorsConfiguration("/swagger-resources", this.corsConfiguration);
            source.registerCorsConfiguration("/swagger-ui/**", this.corsConfiguration);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

