/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.technical.infrastructure.primary.exception;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.violations.ConstraintViolationProblem;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.technical.infrastructure.primary.exception.BadRequestAlertException;
import tech.jhipster.lite.technical.infrastructure.primary.exception.ErrorConstants;
import tech.jhipster.lite.technical.infrastructure.primary.exception.FieldErrorDTO;
import tech.jhipster.lite.technical.infrastructure.primary.exception.HeaderUtil;

@Order(value=100)
@ControllerAdvice
class ExceptionTranslator
implements ProblemHandling {
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private static final String MESSAGE_KEY = "message";
    private static final String PATH_KEY = "path";
    private static final String VIOLATIONS_KEY = "violations";
    @Value(value="${spring.application.name:jhlite}")
    private String applicationName;
    @Value(value="${application.exception.details:false}")
    private boolean exceptionWithDetails;
    @Value(value="${application.exception.package}")
    private final List<String> packages = List.of();

    ExceptionTranslator() {
    }

    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null) {
            return null;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String requestUri = nativeRequest != null ? nativeRequest.getRequestURI() : "";
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with(PATH_KEY, (Object)requestUri);
        if (problem instanceof ConstraintViolationProblem) {
            ConstraintViolationProblem constraintViolationProblem = (ConstraintViolationProblem)problem;
            builder.with(VIOLATIONS_KEY, (Object)constraintViolationProblem.getViolations()).with(MESSAGE_KEY, (Object)"error.validation");
        } else {
            builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey(MESSAGE_KEY)) {
                builder.with(MESSAGE_KEY, (Object)("error.http." + this.getStatusCode(problem)));
            }
        }
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }

    private Integer getStatusCode(Problem problem) {
        return Optional.ofNullable(problem.getStatus()).map(StatusType::getStatusCode).orElse(500);
    }

    public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @Nonnull NativeWebRequest request) {
        BindingResult result = ex.getBindingResult();
        List<FieldErrorDTO> fieldErrors = result.getFieldErrors().stream().map(f -> new FieldErrorDTO(f.getObjectName().replaceFirst("DTO$", ""), f.getField(), this.getMessage((FieldError)f))).toList();
        ThrowableProblem problem = Problem.builder().withType(ErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("Method argument not valid").withStatus(this.defaultConstraintViolationStatus()).with(MESSAGE_KEY, (Object)"error.validation").with(FIELD_ERRORS_KEY, fieldErrors).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    private String getMessage(FieldError f) {
        return StringUtils.isNotBlank((CharSequence)f.getDefaultMessage()) ? f.getDefaultMessage() : f.getCode();
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleBadRequestAlertException(BadRequestAlertException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, HeaderUtil.createFailureAlert(this.applicationName, ex.getEntityName(), ex.getErrorKey()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleGenerationException(GeneratorException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withTitle(ex.getMessage()).build();
        return this.create(ex, (Problem)problem, request);
    }

    public ProblemBuilder prepare(Throwable throwable, StatusType status, URI type) {
        if (!this.exceptionWithDetails) {
            if (throwable instanceof HttpMessageConversionException) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unable to convert http message");
            }
            if (this.containsPackageName(throwable.getMessage())) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unexpected runtime exception");
            }
        }
        return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage());
    }

    private boolean containsPackageName(String message) {
        return this.packages != null && StringUtils.containsAny((CharSequence)message, (CharSequence[])this.packages.toArray(new CharSequence[0]));
    }
}

