/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.cache.ehcache.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class EHCacheModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/cache/ehcache");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final String EHCACHE_GROUP = "org.ehcache";
    private static final String CACHE_SECONDARY = "technical/infrastructure/secondary/cache";

    public JHipsterModule buildJavaConfigurationModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath).append(CACHE_SECONDARY);
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(packagePath).append(CACHE_SECONDARY);
        return this.commonEHCacheModuleBuilder(properties).files().add(MAIN_SOURCE.template("JavaCacheConfiguration.java"), mainDestination.append("CacheConfiguration.java")).add(MAIN_SOURCE.template("EhcacheProperties.java"), mainDestination.append("EhcacheProperties.java")).add(TEST_SOURCE.template("JavaCacheConfigurationIT.java"), testDestination.append("CacheConfigurationIT.java")).add(TEST_SOURCE.template("CacheConfigurationTest.java"), testDestination.append("CacheConfigurationTest.java")).and().springMainProperties().set(JHipsterModule.propertyKey("application.cache.ehcache.max-entries"), JHipsterModule.propertyValue("100")).set(JHipsterModule.propertyKey("application.cache.ehcache.time-to-live-seconds"), JHipsterModule.propertyValue("3600")).and().build();
    }

    public JHipsterModule buildXmlConfigurationModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return this.commonEHCacheModuleBuilder(properties).javaDependencies().addDependency(JHipsterModule.groupId("jakarta.xml.bind"), JHipsterModule.artifactId("jakarta.xml.bind-api")).addDependency(this.jaxbRuntimeDependency()).and().files().add(MAIN_SOURCE.template("XmlCacheConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(CACHE_SECONDARY).append("CacheConfiguration.java")).add(SOURCE.file("resources/ehcache.xml"), JHipsterModule.to("src/main/resources/config/ehcache/ehcache.xml")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.cache.jcache.config"), JHipsterModule.propertyValue("classpath:config/ehcache/ehcache.xml")).and().build();
    }

    private JavaDependency jaxbRuntimeDependency() {
        return JHipsterModule.javaDependency().groupId("org.glassfish.jaxb").artifactId("jaxb-runtime").scope(JavaDependencyScope.RUNTIME).build();
    }

    private JHipsterModule.JHipsterModuleBuilder commonEHCacheModuleBuilder(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-cache")).addDependency(JHipsterModule.groupId("javax.cache"), JHipsterModule.artifactId("cache-api")).addDependency(JHipsterModule.groupId(EHCACHE_GROUP), JHipsterModule.artifactId("ehcache")).and().springMainLogger(EHCACHE_GROUP, LogLevel.WARN).springTestLogger(EHCACHE_GROUP, LogLevel.WARN);
    }
}

