/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.customjhlite.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.cucumbercommon.domain.CucumbersModules;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;

public class CustomJHLiteModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/custom-jhlite");
    private static final JHipsterSource CUCUMBER_SOURCE = JHipsterModule.from("server/springboot/cucumber");
    private static final String SRC_MAIN_JAVA = "src/main/java";
    private static final PropertyKey EXCEPTION_PACKAGE_KEY = JHipsterModule.propertyKey("application.exception.package");
    private static final PropertyKey SERVER_PORT_KEY = JHipsterModule.propertyKey("server.port");
    private static final PropertyKey JACKSON_INCLUSION_KEY = JHipsterModule.propertyKey("spring.jackson.default-property-inclusion");
    private static final PropertyKey HIDDEN_TAGS_PROPERTY_KEY = JHipsterModule.propertyKey("jhlite-hidden-resources.tags");
    private static final PropertyKey HIDDEN_SLUGS_PROPERTY_KEY = JHipsterModule.propertyKey("jhlite-hidden-resources.slugs");
    private static final PropertyKey BEAN_DEFINITION_OVERRIDING_PROPERTY_KEY = JHipsterModule.propertyKey("spring.main.allow-bean-definition-overriding");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        PropertyValue exceptionPackages = this.exceptionPackages(properties);
        JHipsterDestination cucumberDestination = JHipsterModule.toSrcTestJava().append(packagePath).append("cucumber");
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)CucumbersModules.cucumberModuleBuilder(properties).context().put("applicationName", properties.projectBaseName().capitalized()).and().documentation(JHipsterModule.documentationTitle("Module creation"), SOURCE.template("module-creation.md")).documentation(JHipsterModule.documentationTitle("Cucumber"), CUCUMBER_SOURCE.template("cucumber.md")).javaDependencies().addDependency(this.jhipsterLiteDependency()).addDependency(this.jhipsterLiteTestDependency()).and().mandatoryReplacements().in(this.mainClassFile(properties)).add(JHipsterModule.text("@SpringBootApplication"), this.springBootApplicationWithJHLite(properties))).add(JHipsterModule.lineBeforeText("import org.springframework.boot.SpringApplication;"), "import tech.jhipster.lite.JHLiteApp;")).and()).and().springMainProperties().set(EXCEPTION_PACKAGE_KEY, exceptionPackages).set(SERVER_PORT_KEY, JHipsterModule.propertyValue(properties.serverPort().stringValue())).set(JACKSON_INCLUSION_KEY, JHipsterModule.propertyValue("non_null")).set(HIDDEN_TAGS_PROPERTY_KEY, JHipsterModule.propertyValue("banner")).set(HIDDEN_SLUGS_PROPERTY_KEY, JHipsterModule.propertyValue("custom-jhlite")).and().springTestProperties().set(EXCEPTION_PACKAGE_KEY, exceptionPackages).set(SERVER_PORT_KEY, JHipsterModule.propertyValue("0")).set(BEAN_DEFINITION_OVERRIDING_PROPERTY_KEY, JHipsterModule.propertyValue("true")).and().files().add(SOURCE.template("CucumberTest.java"), cucumberDestination.append("CucumberTest.java")).add(SOURCE.template("CucumberConfiguration.java"), cucumberDestination.append("CucumberConfiguration.java")).add(CUCUMBER_SOURCE.template("CucumberRestTemplate.java"), cucumberDestination.append("CucumberRestTemplate.java")).add(CUCUMBER_SOURCE.file("gitkeep"), JHipsterModule.to("src/test/features/.gitkeep")).and().build();
    }

    private JavaDependency jhipsterLiteDependency() {
        return this.jhLiteDependencyBuilder().build();
    }

    private JavaDependency jhipsterLiteTestDependency() {
        return this.jhLiteDependencyBuilder().classifier("tests").scope(JavaDependencyScope.TEST).type(JavaDependencyType.TEST_JAR).build();
    }

    private JavaDependency.JavaDependencyOptionalValueBuilder jhLiteDependencyBuilder() {
        return JHipsterModule.javaDependency().groupId("tech.jhipster.lite").artifactId("jhlite").versionSlug("jhlite");
    }

    private String springBootApplicationWithJHLite(JHipsterModuleProperties properties) {
        return "@SpringBootApplication(scanBasePackageClasses = { JHLiteApp.class, " + this.mainClassName(properties) + ".class })";
    }

    private JHipsterProjectFilePath mainClassFile(JHipsterModuleProperties properties) {
        return JHipsterModule.path(SRC_MAIN_JAVA).append(properties.packagePath()).append(this.mainClassName(properties) + ".java");
    }

    private String mainClassName(JHipsterModuleProperties properties) {
        return properties.projectBaseName().capitalized() + "App";
    }

    private PropertyValue exceptionPackages(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("org.", "java.", "net.", "javax.", "com.", "io.", "de.", "tech.jhipster.lite", properties.basePackage().get());
    }
}

