/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.mariadb.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.database.common.domain.DatabaseType;
import tech.jhipster.lite.generator.server.springboot.database.sqlcommon.domain.SQLCommonModuleBuilder;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class MariaDBModuleFactory {
    private final DockerImages dockerImages;

    public MariaDBModuleFactory(DockerImages dockerImages) {
        Assert.notNull("dockerImages", dockerImages);
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MARIADB, this.dockerImages.get("mariadb"), JHipsterModule.documentationTitle("MariaDB"), JHipsterModule.artifactId("mariadb")).javaDependencies().addDependency(JHipsterModule.groupId("org.mariadb.jdbc"), JHipsterModule.artifactId("mariadb-java-client")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("org.mariadb.jdbc.Driver")).and().build();
    }
}

