/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.mssql.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.database.common.domain.DatabaseType;
import tech.jhipster.lite.generator.server.springboot.database.sqlcommon.domain.SQLCommonModuleBuilder;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;

public class MsSQLModuleFactory {
    private final DockerImages dockerImages;

    public MsSQLModuleFactory(DockerImages dockerImages) {
        Assert.notNull("dockerImages", dockerImages);
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        DockerImageVersion dockerImage = this.dockerImages.get("mcr.microsoft.com/mssql/server");
        JHipsterSource source = JHipsterModule.from("server/springboot/database/" + DatabaseType.MSSQL.id());
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MSSQL, dockerImage, JHipsterModule.documentationTitle("MsSQL"), JHipsterModule.artifactId("mssqlserver")).files().add(source.template("container-license-acceptance.txt"), JHipsterModule.to("src/test/resources/container-license-acceptance.txt")).add(source.template("MsSQLTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(properties.basePackage().path()).append("MsSQLTestContainerExtension.java")).and().javaDependencies().addDependency(JHipsterModule.groupId("com.microsoft.sqlserver"), JHipsterModule.artifactId("mssql-jdbc")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true")).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("yourStrong(!)Password")).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("com.microsoft.sqlserver.jdbc.SQLServerDriver")).set(JHipsterModule.propertyKey("spring.jpa.hibernate.ddl-auto"), JHipsterModule.propertyValue("update")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.criteria.literal_handling_mode"), JHipsterModule.propertyValue("BIND")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.dialect"), JHipsterModule.propertyValue("org.hibernate.dialect.SQLServer2012Dialect")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.format_sql"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.jdbc.fetch_size"), JHipsterModule.propertyValue("150")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:tc:sqlserver:///;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true?TC_TMPFS=/testtmpfs:rw")).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("yourStrong(!)Password")).and().mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(properties.basePackage().path()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(MsSQLTestContainerExtension.class)")).and()).and().springMainLogger("com.microsoft.sqlserver", LogLevel.WARN).springMainLogger("org.reflections", LogLevel.WARN).build();
    }
}

