/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.sqlcommon.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.database.common.domain.DatabaseType;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SQLCommonModuleBuilder {
    private static final String ORG_HIBERNATE = "org.hibernate";
    private static final PropertyValue FALSE = JHipsterModule.propertyValue("false");
    private static final PropertyValue TRUE = JHipsterModule.propertyValue("true");

    private SQLCommonModuleBuilder() {
    }

    public static JHipsterModule.JHipsterModuleBuilder sqlCommonModuleBuilder(JHipsterModuleProperties properties, DatabaseType databaseType, DockerImageVersion dockerImage, DocumentationTitle documentationTitle, ArtifactId testContainerArtifactId) {
        Assert.notNull("properties", properties);
        Assert.notNull("databaseType", (Object)databaseType);
        Assert.notNull("dockerImage", dockerImage);
        Assert.notNull("documentationTitle", documentationTitle);
        Assert.notNull("testContainerArtifactId", testContainerArtifactId);
        String databaseId = databaseType.id();
        JHipsterSource source = JHipsterModule.from("server/springboot/database/" + databaseType.id());
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(properties.packagePath()).append("technical/infrastructure/secondary/").append(databaseId);
        return JHipsterModule.moduleBuilder(properties).context().put("applicationName", properties.projectBaseName().capitalized()).put("srcMainDocker", "src/main/docker").put(databaseId + "DockerImageWithVersion", dockerImage.fullName()).and().documentation(documentationTitle, source.template(databaseId + ".md")).startupCommand(SQLCommonModuleBuilder.startupCommand(databaseId)).files().add(source.template("DatabaseConfiguration.java"), mainDestination.append("DatabaseConfiguration.java")).add(source.template(databaseId + ".yml"), JHipsterModule.toSrcMainDocker().append(databaseId + ".yml")).and().javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-data-jpa")).addDependency(JHipsterModule.groupId("com.zaxxer"), JHipsterModule.artifactId("HikariCP")).addDependency(JHipsterModule.groupId(ORG_HIBERNATE), JHipsterModule.artifactId("hibernate-core")).addDependency(SQLCommonModuleBuilder.testContainer(testContainerArtifactId)).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey("spring.datasource.type"), JHipsterModule.propertyValue("com.zaxxer.hikari.HikariDataSource")).set(JHipsterModule.propertyKey("spring.datasource.hikari.poolName"), JHipsterModule.propertyValue("Hikari")).set(JHipsterModule.propertyKey("spring.datasource.hikari.auto-commit"), FALSE).set(JHipsterModule.propertyKey("spring.data.jpa.repositories.bootstrap-mode"), JHipsterModule.propertyValue("deferred")).set(JHipsterModule.propertyKey("spring.jpa.hibernate.ddl-auto"), JHipsterModule.propertyValue("none")).set(JHipsterModule.propertyKey("spring.jpa.hibernate.naming.implicit-strategy"), JHipsterModule.propertyValue("org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy")).set(JHipsterModule.propertyKey("spring.jpa.hibernate.naming.physical-strategy"), JHipsterModule.propertyValue("org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy")).set(JHipsterModule.propertyKey("spring.jpa.open-in-view"), FALSE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.cache.use_second_level_cache"), FALSE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.cache.use_query_cache"), FALSE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.connection.provider_disables_autocommit"), TRUE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.generate_statistics"), FALSE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.id.new_generator_mappings"), TRUE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.jdbc.batch_size"), JHipsterModule.propertyValue("25")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.jdbc.time_zone"), JHipsterModule.propertyValue("UTC")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.order_inserts"), TRUE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.order_updates"), TRUE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.query.fail_on_pagination_over_collection_fetch"), TRUE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.query.in_clause_parameter_padding"), TRUE).and().springTestProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:tc:" + dockerImage.fullName() + ":///" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue(properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("org.testcontainers.jdbc.ContainerDatabaseDriver")).set(JHipsterModule.propertyKey("spring.datasource.hikari.maximum-pool-size"), JHipsterModule.propertyValue("2")).set(JHipsterModule.propertyKey("spring.jpa.open-in-view"), FALSE).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.connection.provider_disables_autocommit"), TRUE).set(JHipsterModule.propertyKey("spring.datasource.hikari.auto-commit"), FALSE).and().springMainLogger("org.hibernate.validator", LogLevel.WARN).springMainLogger(ORG_HIBERNATE, LogLevel.WARN).springMainLogger("org.hibernate.ejb.HibernatePersistence", LogLevel.OFF).springTestLogger("org.hibernate.validator", LogLevel.WARN).springTestLogger(ORG_HIBERNATE, LogLevel.WARN).springTestLogger("org.hibernate.ejb.HibernatePersistence", LogLevel.OFF).springTestLogger("com.github.dockerjava", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN);
    }

    private static JavaDependency testContainer(ArtifactId testContainerArtifactI) {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId(testContainerArtifactI).versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }

    private static String startupCommand(String databaseId) {
        return "docker compose -f src/main/docker/" + databaseId + ".yml up -d";
    }
}

