/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.liquibase.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class LiquibaseModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/dbmigration/liquibase");
    private static final String LIQUIBASE_SECONDARY = "technical/infrastructure/secondary/liquibase";
    private static final String LIQUIBASE = "liquibase";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(JHipsterModule.groupId("org.liquibase"), JHipsterModule.artifactId("liquibase-core"), JHipsterModule.versionSlug(LIQUIBASE)).addDependency(this.h2Dependency()).and().files().add(SOURCE.file("resources/master.xml"), JHipsterModule.to("src/main/resources/config/liquibase/master.xml")).batch(SOURCE.append("main"), JHipsterModule.toSrcMainJava().append(packagePath).append(LIQUIBASE_SECONDARY)).addTemplate("AsyncSpringLiquibase.java").addTemplate("LiquibaseConfiguration.java").addTemplate("SpringLiquibaseUtil.java").and().batch(SOURCE.append("test"), JHipsterModule.toSrcTestJava().append(packagePath).append(LIQUIBASE_SECONDARY)).addTemplate("AsyncSpringLiquibaseTest.java").addTemplate("LiquibaseConfigurationIT.java").addTemplate("SpringLiquibaseUtilTest.java").and().add(SOURCE.template("test/LogbackRecorder.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("LogbackRecorder.java")).and().springMainLogger(LIQUIBASE, LogLevel.WARN).springMainLogger("LiquibaseSchemaResolver", LogLevel.INFO).springMainLogger("com.zaxxer.hikari", LogLevel.WARN).springTestLogger(LIQUIBASE, LogLevel.WARN).springTestLogger("LiquibaseSchemaResolver", LogLevel.INFO).springTestLogger("com.zaxxer.hikari", LogLevel.WARN).build();
    }

    private JavaDependency h2Dependency() {
        return JHipsterModule.javaDependency().groupId("com.h2database").artifactId("h2").scope(JavaDependencyScope.TEST).build();
    }
}

