/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.devtools.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class DevToolsModuleFactory {
    private static final GroupId SPRING_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/devtools");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        JHipsterModule.JHipsterModuleBuilder builder = JHipsterModule.moduleBuilder(properties).context().put("applicationName", properties.projectBaseName().capitalized()).and();
        this.appendDependencies(builder);
        this.appendSpringProperties(builder);
        builder.documentation(JHipsterModule.documentationTitle("Dev tools"), SOURCE.append("devtools.md.mustache"));
        return builder.build();
    }

    private void appendDependencies(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.javaDependencies().addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-devtools"));
    }

    private void appendSpringProperties(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.springMainProperties().set(JHipsterModule.propertyKey("spring.devtools.livereload.enabled"), JHipsterModule.propertyValue("false")).set(JHipsterModule.propertyKey("spring.devtools.restart.enabled"), JHipsterModule.propertyValue("false"));
        builder.springMainProperties(new SpringProfile("local")).set(JHipsterModule.propertyKey("spring.devtools.livereload.enabled"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("spring.devtools.restart.enabled"), JHipsterModule.propertyValue("true"));
    }
}

