/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.web.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SpringBootMvcsModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/web");
    private static final GroupId SPRING_BOOT_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final ArtifactId STARTER_WEB_ARTIFACT_ID = JHipsterModule.artifactId("spring-boot-starter-web");
    private static final PropertyKey SERVER_PORT = JHipsterModule.propertyKey("server.port");
    private static final String CORS_PRIMARY = "security/infrastructure/primary";

    public JHipsterModule buildTomcatModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return this.springMvcBuilder(properties, "org.springframework.web", LogLevel.ERROR).javaDependencies().addDependency(SPRING_BOOT_GROUP, STARTER_WEB_ARTIFACT_ID).and().build();
    }

    public JHipsterModule buildUndertowModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return this.springMvcBuilder(properties, "io.undertow", LogLevel.WARN).javaDependencies().addDependency(this.springBootWebWithoutTomcatDependency()).addDependency(SPRING_BOOT_GROUP, JHipsterModule.artifactId("spring-boot-starter-undertow")).and().build();
    }

    private JavaDependency springBootWebWithoutTomcatDependency() {
        return JHipsterModule.javaDependency().groupId(SPRING_BOOT_GROUP).artifactId(STARTER_WEB_ARTIFACT_ID).addExclusion(SPRING_BOOT_GROUP, JHipsterModule.artifactId("spring-boot-starter-tomcat")).build();
    }

    private JHipsterModule.JHipsterModuleBuilder springMvcBuilder(JHipsterModuleProperties properties, String loggerName, LogLevel logLevel) {
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("CORS configuration"), SOURCE.file("cors-configuration.md")).localEnvironment(JHipsterModule.localEnvironment("- [Local server](http://localhost:" + properties.serverPort().get() + ")")).javaDependencies().addDependency(SPRING_BOOT_GROUP, JHipsterModule.artifactId("spring-boot-starter-validation")).addDependency(this.reflectionsDependency()).and().springMainProperties().set(SERVER_PORT, JHipsterModule.propertyValue(properties.serverPort().stringValue())).and().springTestProperties().set(SERVER_PORT, JHipsterModule.propertyValue("0")).and().files().batch(SOURCE.append("src/cors"), JHipsterModule.toSrcMainJava().append(packagePath).append(CORS_PRIMARY)).addTemplate("CorsFilterConfiguration.java").addTemplate("CorsProperties.java").and().add(SOURCE.append("test/cors").template("CorsFilterConfigurationIT.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(CORS_PRIMARY).append("CorsFilterConfigurationIT.java")).add(SOURCE.append("test").template("JsonHelper.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("JsonHelper.java")).batch(SOURCE.append("test"), JHipsterModule.toSrcTestJava().append(properties.packagePath())).addTemplate("BeanValidationAssertions.java").addTemplate("BeanValidationTest.java").and().and().springTestLogger(loggerName, logLevel).springMainLogger(loggerName, logLevel);
    }

    private JavaDependency reflectionsDependency() {
        return JHipsterModule.javaDependency().groupId("org.reflections").artifactId("reflections").versionSlug("reflections").scope(JavaDependencyScope.TEST).build();
    }
}

