/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.webflux.web.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SpringBootWebfluxModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/webflux/web");
    private static final PropertyKey SERVER_PORT = JHipsterModule.propertyKey("server.port");
    private static final PropertyKey EXCEPTION_PACKAGE = JHipsterModule.propertyKey("application.exception.package");
    private static final GroupId SPRING_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final String EXCEPTION_PRIMARY = "technical/infrastructure/primary/exception";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-webflux")).addDependency(this.reactorTestDependency()).addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-validation")).addDependency(this.webfluxProblemDependency()).and().springMainProperties().set(SERVER_PORT, JHipsterModule.propertyValue(properties.serverPort().stringValue())).set(JHipsterModule.propertyKey("application.exception.details"), JHipsterModule.propertyValue("false")).set(EXCEPTION_PACKAGE, JHipsterModule.propertyValue("org.", "java.", "net.", "javax.", "com.", "io.", "de.", properties.basePackage().get())).and().springTestProperties().set(SERVER_PORT, JHipsterModule.propertyValue("0")).set(EXCEPTION_PACKAGE, JHipsterModule.propertyValue("org.", "java.")).and().files().batch(SOURCE.append("main"), JHipsterModule.toSrcMainJava().append(packagePath).append(EXCEPTION_PRIMARY)).addTemplate("BadRequestAlertException.java").addTemplate("ErrorConstants.java").addTemplate("ExceptionTranslator.java").addTemplate("FieldErrorDTO.java").addTemplate("HeaderUtil.java").addTemplate("ProblemConfiguration.java").and().batch(SOURCE.append("test"), JHipsterModule.toSrcTestJava().append(packagePath).append(EXCEPTION_PRIMARY)).addTemplate("HeaderUtilTest.java").addTemplate("BadRequestAlertExceptionTest.java").addTemplate("ExceptionTranslatorIT.java").addTemplate("ExceptionTranslatorTestController.java").addTemplate("FieldErrorDTOTest.java").and().add(SOURCE.template("test/TestUtil.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestUtil.java")).and().build();
    }

    private JavaDependency reactorTestDependency() {
        return JHipsterModule.javaDependency().groupId("io.projectreactor").artifactId("reactor-test").scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency webfluxProblemDependency() {
        return JHipsterModule.javaDependency().groupId("org.zalando").artifactId("problem-spring-webflux").versionSlug("problem-spring").build();
    }
}

