/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import tech.jhipster.lite.error.domain.Assert;

public class JHipsterSource {
    private static final String MUSTACHE_EXTENSION = ".mustache";
    private final Path source;

    public JHipsterSource(Path source) {
        Assert.notNull("source", source);
        this.source = source;
    }

    public Path get() {
        return this.source;
    }

    public JHipsterSource template(String file) {
        Assert.notBlank("file", file);
        if (this.isTemplate(file)) {
            return this.file(file);
        }
        return this.file(file + MUSTACHE_EXTENSION);
    }

    public JHipsterSource append(String element) {
        return this.file(element);
    }

    public JHipsterSource file(String file) {
        return new JHipsterSource(this.source.resolve(file));
    }

    public String extension() {
        String filename = this.source.getFileName().toString();
        if (this.isTemplate(filename)) {
            return this.findExtension(filename.substring(0, filename.length() - MUSTACHE_EXTENSION.length()));
        }
        return this.findExtension(filename);
    }

    private String findExtension(String filename) {
        return "." + FilenameUtils.getExtension((String)filename);
    }

    public boolean isNotTemplate() {
        return !this.isTemplate(this.source.getFileName().toString());
    }

    private boolean isTemplate(String filename) {
        return filename.endsWith(MUSTACHE_EXTENSION);
    }
}

