/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.common.domain.JHipsterCollections;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javadependency.DependenciesCommandsFactory;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;

public class JavaDependency {
    private final DependencyId id;
    private final Optional<VersionSlug> versionSlug;
    private final Optional<JavaDependencyClassifier> classifier;
    private final JavaDependencyScope scope;
    private final boolean optional;
    private final Optional<JavaDependencyType> type;
    private final Collection<DependencyId> exclusions;

    private JavaDependency(JavaDependencyBuilder builder) {
        this.id = new DependencyId(builder.groupId, builder.artifactId);
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
        this.classifier = Optional.ofNullable(builder.classifier);
        this.scope = JavaDependencyScope.from(builder.scope);
        this.optional = builder.optional;
        this.type = Optional.ofNullable(builder.type);
        this.exclusions = JHipsterCollections.immutable(builder.exclusions);
    }

    public static JavaDependencyGroupIdBuilder builder() {
        return new JavaDependencyBuilder();
    }

    Collection<JavaBuildCommand> versionCommands(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return this.version().flatMap(this.toVersion(currentVersions, projectDependencies)).map(this.toSetVersionCommand()).map(List::of).orElse(List.of());
    }

    private Function<VersionSlug, Optional<JavaDependencyVersion>> toVersion(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return slug -> {
            JavaDependencyVersion currentVersion = currentVersions.get((VersionSlug)slug);
            return projectDependencies.version((VersionSlug)slug).map(this.toVersionToUse(currentVersion)).orElseGet(() -> Optional.of(currentVersion));
        };
    }

    private Function<JavaDependencyVersion, Optional<JavaDependencyVersion>> toVersionToUse(JavaDependencyVersion currentVersion) {
        return version -> {
            if (version.equals(currentVersion)) {
                return Optional.empty();
            }
            return Optional.of(currentVersion);
        };
    }

    private Function<JavaDependencyVersion, JavaBuildCommand> toSetVersionCommand() {
        return SetVersion::new;
    }

    Collection<JavaBuildCommand> dependencyCommands(DependenciesCommandsFactory commands, Optional<JavaDependency> projectDependency) {
        return projectDependency.map(this.toDependenciesCommands(commands)).orElseGet(() -> List.of(commands.addDependency(this)));
    }

    private Function<JavaDependency, Collection<JavaBuildCommand>> toDependenciesCommands(DependenciesCommandsFactory commands) {
        return projectDependency -> {
            Collection<JavaDependency> resultingDependencies = this.merge((JavaDependency)projectDependency);
            if (resultingDependencies.size() == 1 && resultingDependencies.contains(projectDependency)) {
                return List.of();
            }
            return Stream.concat(Stream.of(commands.removeDependency(this.id())), resultingDependencies.stream().map(commands::addDependency)).toList();
        };
    }

    private Collection<JavaDependency> merge(JavaDependency other) {
        ArrayList<JavaDependency> resultingDependencies = new ArrayList<JavaDependency>();
        resultingDependencies.add(this.merge(other, this.type, this.classifier));
        if (!this.type.equals(other.type)) {
            resultingDependencies.add(this.merge(other, other.type, this.classifier));
        }
        if (!this.classifier.equals(other.classifier)) {
            resultingDependencies.add(this.merge(other, this.type, other.classifier));
        }
        return resultingDependencies;
    }

    private JavaDependency merge(JavaDependency other, Optional<JavaDependencyType> resultingType, Optional<JavaDependencyClassifier> resultingClassifier) {
        return JavaDependency.builder().groupId(this.groupId()).artifactId(this.artifactId()).versionSlug(this.mergeVersionsSlugs(other)).classifier((JavaDependencyClassifier)resultingClassifier.orElse(null)).scope(this.mergeScopes(other)).optional(this.mergeOptionalFlag(other)).type(resultingType.orElse(null)).build();
    }

    private VersionSlug mergeVersionsSlugs(JavaDependency other) {
        return this.versionSlug.orElseGet(() -> other.versionSlug.orElse(null));
    }

    private JavaDependencyScope mergeScopes(JavaDependency other) {
        return this.scope.merge(other.scope);
    }

    private boolean mergeOptionalFlag(JavaDependency other) {
        return this.optional && other.optional;
    }

    public DependencyId id() {
        return this.id;
    }

    public Optional<VersionSlug> version() {
        return this.versionSlug;
    }

    public Optional<JavaDependencyClassifier> classifier() {
        return this.classifier;
    }

    public boolean optional() {
        return this.optional;
    }

    public JavaDependencyScope scope() {
        return this.scope;
    }

    public Optional<JavaDependencyType> type() {
        return this.type;
    }

    public Collection<DependencyId> exclusions() {
        return this.exclusions;
    }

    private GroupId groupId() {
        return this.id.groupId();
    }

    private ArtifactId artifactId() {
        return this.id.artifactId();
    }

    @Generated
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.versionSlug).append(this.classifier).append((Object)this.scope).append(this.optional).append(this.type).hashCode();
    }

    @Generated
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaDependency other = (JavaDependency)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).append(this.versionSlug, other.versionSlug).append(this.classifier, other.classifier).append((Object)this.scope, (Object)other.scope).append(this.optional, other.optional).append(this.type, other.type).isEquals();
    }

    public static class JavaDependencyBuilder
    implements JavaDependencyGroupIdBuilder,
    JavaDependencyArtifactIdBuilder,
    JavaDependencyOptionalValueBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private VersionSlug versionSlug;
        private JavaDependencyClassifier classifier;
        private JavaDependencyScope scope;
        private boolean optional;
        private JavaDependencyType type;
        private final Collection<DependencyId> exclusions = new ArrayList<DependencyId>();

        private JavaDependencyBuilder() {
        }

        @Override
        public JavaDependencyArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder classifier(JavaDependencyClassifier classifier) {
            this.classifier = classifier;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder scope(JavaDependencyScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder type(JavaDependencyType type) {
            this.type = type;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder addExclusion(DependencyId dependency) {
            Assert.notNull("dependency", dependency);
            this.exclusions.add(dependency);
            return this;
        }

        @Override
        public JavaDependency build() {
            return new JavaDependency(this);
        }
    }

    public static interface JavaDependencyGroupIdBuilder {
        public JavaDependencyArtifactIdBuilder groupId(GroupId var1);

        default public JavaDependencyArtifactIdBuilder groupId(String groupId) {
            return this.groupId(new GroupId(groupId));
        }
    }

    public static interface JavaDependencyArtifactIdBuilder {
        public JavaDependencyOptionalValueBuilder artifactId(ArtifactId var1);

        default public JavaDependencyOptionalValueBuilder artifactId(String artifactId) {
            return this.artifactId(new ArtifactId(artifactId));
        }
    }

    public static interface JavaDependencyOptionalValueBuilder {
        public JavaDependencyOptionalValueBuilder versionSlug(VersionSlug var1);

        public JavaDependencyOptionalValueBuilder classifier(JavaDependencyClassifier var1);

        public JavaDependencyOptionalValueBuilder scope(JavaDependencyScope var1);

        public JavaDependencyOptionalValueBuilder optional(boolean var1);

        public JavaDependencyOptionalValueBuilder type(JavaDependencyType var1);

        public JavaDependencyOptionalValueBuilder addExclusion(DependencyId var1);

        public JavaDependency build();

        default public JavaDependencyOptionalValueBuilder versionSlug(String versionSlug) {
            return this.versionSlug((VersionSlug)VersionSlug.of(versionSlug).orElse(null));
        }

        default public JavaDependencyOptionalValueBuilder classifier(String classifier) {
            return this.classifier((JavaDependencyClassifier)JavaDependencyClassifier.of(classifier).orElse(null));
        }

        default public JavaDependencyOptionalValueBuilder optional() {
            return this.optional(true);
        }

        default public JavaDependencyOptionalValueBuilder addExclusion(GroupId groupId, ArtifactId artifactId) {
            return this.addExclusion(new DependencyId(groupId, artifactId));
        }
    }
}

