/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import tech.jhipster.lite.module.application.JHipsterModulesApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;
import tech.jhipster.lite.module.infrastructure.primary.JHipsterModuleApplicationController;
import tech.jhipster.lite.projectfolder.domain.ProjectFolder;

@Component
class JHipsterModulesPatchApplicationHandlerMapping
extends AbstractUrlHandlerMapping {
    private final Map<String, JHipsterModuleApplicationController> controllers;

    public JHipsterModulesPatchApplicationHandlerMapping(ObjectMapper json, JHipsterModulesResources modulesResources, JHipsterModulesApplicationService modules, ProjectFolder jHipsterProjectFolderFactory) {
        this.controllers = this.buildControllers(json, modulesResources, modules, jHipsterProjectFolderFactory);
    }

    private Map<String, JHipsterModuleApplicationController> buildControllers(ObjectMapper json, JHipsterModulesResources modulesResources, JHipsterModulesApplicationService modules, ProjectFolder jHipsterProjectFolderFactory) {
        return modulesResources.stream().collect(Collectors.toUnmodifiableMap(this.toApplyUrl(), this.toApplyerController(json, modules, jHipsterProjectFolderFactory)));
    }

    private Function<JHipsterModuleResource, String> toApplyUrl() {
        return moduleResource -> moduleResource.moduleUrl() + "/apply-patch";
    }

    private Function<JHipsterModuleResource, JHipsterModuleApplicationController> toApplyerController(ObjectMapper json, JHipsterModulesApplicationService modules, ProjectFolder jHipsterProjectFolderFactory) {
        return module -> new JHipsterModuleApplicationController(json, (JHipsterModuleResource)module, modules, jHipsterProjectFolderFactory);
    }

    protected void initApplicationContext() throws BeansException {
        this.setOrder(2);
        super.initApplicationContext();
        this.registerHandlers();
    }

    private void registerHandlers() {
        this.controllers.forEach((x$0, x$1) -> this.registerHandler((String)x$0, x$1));
    }
}

