/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterModulesToApply;
import tech.jhipster.lite.module.infrastructure.primary.RestJHipsterModuleProperties;
import tech.jhipster.lite.projectfolder.domain.ProjectFolder;

@Schema(name="JHipsterModulesToApply", description="Information to apply multiple modules")
class RestJHipsterModulesToApply {
    private final Collection<String> modules;
    private final RestJHipsterModuleProperties properties;

    RestJHipsterModulesToApply(@JsonProperty(value="modules") Collection<String> modules, @JsonProperty(value="properties") RestJHipsterModuleProperties properties) {
        this.modules = modules;
        this.properties = properties;
    }

    public JHipsterModulesToApply toDomain(ProjectFolder projectFolder) {
        return new JHipsterModulesToApply(this.getModules().stream().map(JHipsterModuleSlug::new).toList(), this.properties.toDomain(projectFolder));
    }

    @NotEmpty
    @Schema(description="Slugs of the modules to apply", required=true)
    public Collection<String> getModules() {
        return this.modules;
    }

    @NotNull
    @Schema(description="Properties for the modules to apply")
    public RestJHipsterModuleProperties getProperties() {
        return this.properties;
    }
}

