/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import org.springframework.stereotype.Repository;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModuleApplied;
import tech.jhipster.lite.module.domain.JHipsterModuleChanges;
import tech.jhipster.lite.module.domain.JHipsterModulesRepository;
import tech.jhipster.lite.module.domain.ProjectFilesReader;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscape;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.postaction.JHipsterModuleExecutionContext;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemJHipsterModuleFiles;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemPackageJsonHandler;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemReplacer;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemSpringPropertiesCommandsHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.FileSystemJavaBuildCommandsHandler;
import tech.jhipster.lite.project.infrastructure.primary.JavaProjects;

@Repository
class FileSystemJHipsterModulesRepository
implements JHipsterModulesRepository {
    private final JavaProjects projects;
    private final JHipsterModulesResources resources;
    private final FileSystemJHipsterModuleFiles files;
    private final FileSystemJavaBuildCommandsHandler javaBuild;
    private final FileSystemSpringPropertiesCommandsHandler springProperties;
    private final FileSystemPackageJsonHandler packageJson;
    private final FileSystemReplacer replacer;
    private final JHipsterLandscape landscape;

    public FileSystemJHipsterModulesRepository(ProjectFilesReader filesReader, NpmVersions npmVersions, JavaProjects projects, JHipsterModulesResources resources) {
        this.projects = projects;
        this.resources = resources;
        this.landscape = JHipsterLandscape.from(resources);
        this.files = new FileSystemJHipsterModuleFiles(filesReader);
        this.javaBuild = new FileSystemJavaBuildCommandsHandler();
        this.springProperties = new FileSystemSpringPropertiesCommandsHandler();
        this.packageJson = new FileSystemPackageJsonHandler(npmVersions);
        this.replacer = new FileSystemReplacer();
    }

    @Override
    public void apply(JHipsterModuleChanges changes) {
        Assert.notNull("changes", changes);
        changes.preActions().run();
        this.files.create(changes.projectFolder(), changes.filesToAdd());
        this.files.move(changes.projectFolder(), changes.filesToMove());
        this.files.delete(changes.projectFolder(), changes.filesToDelete());
        this.javaBuild.handle(changes.indentation(), changes.projectFolder(), changes.javaBuildCommands());
        this.springProperties.handle(changes.projectFolder(), changes.springProperties());
        this.packageJson.handle(changes.indentation(), changes.projectFolder(), changes.packageJson());
        this.replacer.handle(changes.projectFolder(), changes.mandatoryReplacements());
        this.replacer.handle(changes.projectFolder(), changes.optionalReplacements());
        changes.postActions().run(new JHipsterModuleExecutionContext(changes.projectFolder()));
    }

    @Override
    public void applied(JHipsterModuleApplied moduleApplied) {
        this.projects.moduleApplied(moduleApplied);
    }

    @Override
    public JHipsterModulesResources resources() {
        return this.resources;
    }

    @Override
    public JHipsterLandscape landscape() {
        return this.landscape;
    }
}

