/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.jhipster.lite.common.domain.Enums;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.npm.NpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.packagejson.JHipsterModulePackageJson;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependencies;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependency;
import tech.jhipster.lite.module.domain.packagejson.Scripts;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.MissingPackageJsonException;

class FileSystemPackageJsonHandler {
    private static final String QUOTE = "\"";
    private static final String LINE_END = ",";
    private static final String LINE_SEPARATOR = ",\n";
    private final NpmVersions npmVersions;

    public FileSystemPackageJsonHandler(NpmVersions npmVersions) {
        Assert.notNull("npmVersions", npmVersions);
        this.npmVersions = npmVersions;
    }

    public void handle(Indentation indentation, JHipsterProjectFolder projectFolder, JHipsterModulePackageJson packageJson) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("packageJson", packageJson);
        if (packageJson.isEmpty()) {
            return;
        }
        Path file = this.getPackageJsonFile(projectFolder);
        String content = this.readContent(file);
        content = this.replaceScripts(indentation, packageJson.scripts(), content);
        content = this.replaceDevDependencies(indentation, packageJson.devDependencies(), content);
        content = this.replaceDependencies(indentation, packageJson.dependencies(), content);
        content = this.cleanupLineBreaks(indentation, content);
        this.write(file, content);
    }

    private Path getPackageJsonFile(JHipsterProjectFolder projectFolder) {
        Path file = projectFolder.filePath("package.json");
        if (Files.notExists(file, new LinkOption[0])) {
            throw new MissingPackageJsonException(projectFolder);
        }
        return file;
    }

    private String cleanupLineBreaks(Indentation indentation, String content) {
        return content.replaceAll(",(\\s*|[\r\n]*)}", "\n" + indentation.spaces() + "}");
    }

    private String replaceScripts(Indentation indentation, Scripts scripts, String content) {
        return JsonReplacer.builder().blocName("scripts").jsonContent(content).indentation(indentation).entries(this.scriptEntries(scripts)).replace();
    }

    private List<JsonEntry> scriptEntries(Scripts scripts) {
        return scripts.stream().map(script -> new JsonEntry(script.key().get(), script.command().get())).toList();
    }

    private String replaceDevDependencies(Indentation indentation, PackageJsonDependencies devDependencies, String content) {
        return JsonReplacer.builder().blocName("devDependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(devDependencies)).replace();
    }

    private String replaceDependencies(Indentation indentation, PackageJsonDependencies dependencies, String content) {
        return JsonReplacer.builder().blocName("dependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(dependencies)).replace();
    }

    private List<JsonEntry> dependenciesEntries(PackageJsonDependencies devDependencies) {
        return devDependencies.stream().map(dependency -> new JsonEntry(dependency.packageName().get(), this.getNpmVersion((PackageJsonDependency)dependency))).toList();
    }

    private String getNpmVersion(PackageJsonDependency dependency) {
        return this.npmVersions.get(dependency.packageName().get(), Enums.map(dependency.versionSource(), NpmVersionSource.class)).get();
    }

    @Generated(reason="The error handling is an hard to test implementation detail")
    private String readContent(Path file) {
        try {
            return Files.readString(file);
        }
        catch (IOException e) {
            throw new GeneratorException("Error reading " + file.toAbsolutePath().toString() + " content" + e.getMessage(), e);
        }
    }

    @Generated(reason="The error handling is an hard to test implementation detail")
    private void write(Path file, String content) {
        try {
            Files.write(file, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new GeneratorException("Error writing " + file.toAbsolutePath().toString() + ": " + e.getMessage(), e);
        }
    }

    private static class JsonReplacer {
        private final String blocName;
        private final String jsonContent;
        private final Indentation indentation;
        private final Collection<JsonEntry> entries;

        private JsonReplacer(JsonReplacerBuilder builder) {
            this.blocName = builder.blocName;
            this.jsonContent = builder.jsonContent;
            this.indentation = builder.indentation;
            this.entries = builder.entries;
        }

        public static JsonReplacerBuilder builder() {
            return new JsonReplacerBuilder();
        }

        public String handle() {
            if (this.entries.isEmpty()) {
                return this.jsonContent;
            }
            String result = this.removeExistingEntries();
            Matcher blocMatcher = this.buildBlocMatcher(result);
            result = blocMatcher.find() ? this.appendEntries(blocMatcher) : this.appendNewBlock(result);
            return result;
        }

        private String appendEntries(Matcher blocMatcher) {
            return blocMatcher.replaceFirst(match -> {
                StringBuilder result = new StringBuilder().append(match.group(1)).append("\n");
                result.append(this.entriesBloc(this.indentation, this.entries));
                result.append(FileSystemPackageJsonHandler.LINE_END);
                return result.toString();
            });
        }

        private String appendNewBlock(String result) {
            String jsonBloc = FileSystemPackageJsonHandler.LINE_SEPARATOR + this.indentation.spaces() + FileSystemPackageJsonHandler.QUOTE + this.blocName + FileSystemPackageJsonHandler.QUOTE + ": {" + "\n" + this.entriesBloc(this.indentation, this.entries) + "\n" + this.indentation.spaces() + "}";
            return result.replaceFirst("(\\s{1,10})\\}(\\s{1,10})$", jsonBloc + "$1}$2");
        }

        private Matcher buildBlocMatcher(String result) {
            return Pattern.compile("(\"" + this.blocName + "\"\\s*:\\s*\\{)").matcher(result);
        }

        @Generated(reason="Combiner can't be tested and an implementation detail")
        private String removeExistingEntries() {
            return this.entries.stream().map(this.toEntryPattern(this.blocName, this.indentation)).reduce(this.jsonContent, (json, entryPattern) -> entryPattern.matcher((CharSequence)json).replaceAll("$1$2"), (first, second) -> first);
        }

        private Function<JsonEntry, Pattern> toEntryPattern(String blocName, Indentation indentation) {
            return entry -> {
                String pattern = "(\"" + blocName + "\"\\s*:\\s*\\{)([^}]*)(\"" + entry.key() + "\"\\s*:\\s*\"[^\\r\\n]+[\\r\\n]{1,2}(\\s{" + indentation.spacesCount() * 2 + "})?)";
                return Pattern.compile(pattern, 32);
            };
        }

        private String entriesBloc(Indentation indentation, Collection<JsonEntry> entries) {
            return entries.stream().map(entry -> entry.toJson(indentation)).collect(Collectors.joining(FileSystemPackageJsonHandler.LINE_SEPARATOR));
        }

        private static class JsonReplacerBuilder {
            private String blocName;
            private String jsonContent;
            private Indentation indentation;
            private Collection<JsonEntry> entries;

            private JsonReplacerBuilder() {
            }

            private JsonReplacerBuilder blocName(String blocName) {
                this.blocName = blocName;
                return this;
            }

            private JsonReplacerBuilder jsonContent(String jsonContent) {
                this.jsonContent = jsonContent;
                return this;
            }

            private JsonReplacerBuilder indentation(Indentation indentation) {
                this.indentation = indentation;
                return this;
            }

            private JsonReplacerBuilder entries(Collection<JsonEntry> entries) {
                this.entries = entries;
                return this;
            }

            private String replace() {
                return new JsonReplacer(this).handle();
            }
        }
    }

    private record JsonEntry(String key, String value) {
        String toJson(Indentation indentation) {
            return indentation.times(2) + FileSystemPackageJsonHandler.QUOTE + this.key() + FileSystemPackageJsonHandler.QUOTE + ": " + FileSystemPackageJsonHandler.QUOTE + this.value() + FileSystemPackageJsonHandler.QUOTE;
        }
    }
}

