/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency;

import java.util.List;
import java.util.regex.Pattern;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.module.domain.ProjectFilesReader;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesReader;

@Repository
@Order(value=0x7FFFFFFF)
class FileSystemJavaDependenciesReader
implements JavaDependenciesReader {
    private static final String CURRENT_VERSIONS_FILE = "/generator/dependencies/pom.xml";
    private static final Pattern VERSIONS_PATTERN = Pattern.compile("<([^>]+)\\.version>([^>]+)<\\/");
    private final ProjectFilesReader files;

    public FileSystemJavaDependenciesReader(ProjectFilesReader files) {
        this.files = files;
    }

    @Override
    public JavaDependenciesVersions get() {
        List<JavaDependencyVersion> versions = this.readVersions(this.files.readString(CURRENT_VERSIONS_FILE));
        return new JavaDependenciesVersions(versions);
    }

    private List<JavaDependencyVersion> readVersions(String content) {
        return VERSIONS_PATTERN.matcher(content).results().map(result -> new JavaDependencyVersion(result.group(1), result.group(2))).toList();
    }
}

