/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.project.domain.ProjectPath;
import tech.jhipster.lite.project.domain.ProjectsRepository;
import tech.jhipster.lite.project.domain.download.Project;
import tech.jhipster.lite.project.domain.history.ProjectHistory;
import tech.jhipster.lite.project.infrastructure.secondary.FileSystemProjectDownloader;
import tech.jhipster.lite.project.infrastructure.secondary.PersistedProjectHistory;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectFormatter;

@Repository
class FileSystemProjectsRepository
implements ProjectsRepository {
    private static final String PATH_PARAMETER = "path";
    private static final String HISTORY_FOLDER = ".jhipster/modules";
    private static final String HISTORY_FILE = "history.json";
    private final ObjectMapper json;
    private final ProjectFormatter formatter;
    private final ObjectWriter writer;
    private final FileSystemProjectDownloader downloader;

    public FileSystemProjectsRepository(ObjectMapper json, ProjectFormatter formatter) {
        this.json = json;
        this.formatter = formatter;
        this.writer = json.writerWithDefaultPrettyPrinter();
        this.downloader = new FileSystemProjectDownloader();
    }

    @Override
    public void format(ProjectPath path) {
        Assert.notNull(PATH_PARAMETER, path);
        this.formatter.format(path);
    }

    @Override
    public Optional<Project> get(ProjectPath path) {
        Assert.notNull(PATH_PARAMETER, path);
        return this.downloader.download(path);
    }

    @Override
    public void save(ProjectHistory history) {
        Assert.notNull("history", history);
        try {
            Path historyPath = this.historyFilePath(history.path());
            Files.createDirectories(historyPath.getParent(), new FileAttribute[0]);
            Files.write(historyPath, this.writer.writeValueAsBytes((Object)PersistedProjectHistory.from(history)), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GeneratorException("Eror saving history: " + e.getMessage(), e);
        }
    }

    @Override
    public ProjectHistory getHistory(ProjectPath path) {
        Assert.notNull(PATH_PARAMETER, path);
        Path historyFilePath = this.historyFilePath(path);
        if (Files.notExists(historyFilePath, new LinkOption[0])) {
            return ProjectHistory.empty(path);
        }
        try {
            return ((PersistedProjectHistory)this.json.readValue(Files.readAllBytes(historyFilePath), PersistedProjectHistory.class)).toDomain(path);
        }
        catch (IOException e) {
            throw new GeneratorException("Can't read project history: " + e.getMessage(), e);
        }
    }

    private Path historyFilePath(ProjectPath path) {
        return Paths.get(path.get(), HISTORY_FOLDER, HISTORY_FILE);
    }
}

