/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.error.domain;

import java.time.Instant;
import tech.jhipster.lite.error.domain.AssertionErrorType;
import tech.jhipster.lite.error.domain.AssertionException;

public class NotAfterTimeException
extends AssertionException {
    private NotAfterTimeException(String field, String message) {
        super(field, message);
    }

    public static NotAfterTimeException notStrictlyAfter(String fieldName, Instant other) {
        return new NotAfterTimeException(fieldName, NotAfterTimeException.message(fieldName, "must be strictly after", other));
    }

    public static NotAfterTimeException notAfter(String fieldName, Instant other) {
        return new NotAfterTimeException(fieldName, NotAfterTimeException.message(fieldName, "must be after", other));
    }

    private static String message(String fieldName, String hint, Instant other) {
        return "Time in \"" + fieldName + "\" " + hint + " " + other + " but wasn't";
    }

    @Override
    public AssertionErrorType type() {
        return AssertionErrorType.NOT_AFTER_TIME;
    }
}

