/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.buildtool.maven.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class MavenModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("buildtool/maven");
    private static final GroupId APACHE_PLUGINS_GROUP = JHipsterModule.groupId("org.apache.maven.plugins");
    private static final GroupId JACOCO_GROUP = JHipsterModule.groupId("org.jacoco");
    private static final ArtifactId JACOCO_ARTIFACT_ID = JHipsterModule.artifactId("jacoco-maven-plugin");
    private static final VersionSlug JACOCO_VERSION = JHipsterModule.versionSlug("jacoco");

    public JHipsterModule buildMavenModule(JHipsterModuleProperties properties) {
        return this.mavenWrapperModulesFiles(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).and().startupCommand("./mvnw").files().add(SOURCE.template("pom.xml"), JHipsterModule.to("pom.xml")).and().javaDependencies().addDependency(MavenModuleFactory.junitEngineDependency()).addDependency(MavenModuleFactory.junitParamsDependency()).addDependency(MavenModuleFactory.assertjDependency()).addDependency(MavenModuleFactory.mockitoDependency()).and().javaBuildPlugins().plugin(this.mavenCompilerPlugin()).plugin(this.surefirePlugin()).plugin(this.jacocoPlugin()).plugin(this.failsafePlugin()).pluginManagement(this.jacocoPluginManagement()).pluginManagement(this.enforcerPluginManagement()).and().build();
    }

    private static JavaDependency junitEngineDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-engine").versionSlug("junit-jupiter.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency junitParamsDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-params").versionSlug("junit-jupiter.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency assertjDependency() {
        return JHipsterModule.javaDependency().groupId("org.assertj").artifactId("assertj-core").versionSlug("assertj.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency mockitoDependency() {
        return JHipsterModule.javaDependency().groupId("org.mockito").artifactId("mockito-junit-jupiter").versionSlug("mockito.version").scope(JavaDependencyScope.TEST).build();
    }

    public JHipsterModule buildMavenWrapperModule(JHipsterModuleProperties properties) {
        return this.mavenWrapperModulesFiles(properties).build();
    }

    private JHipsterModule.JHipsterModuleBuilder mavenWrapperModulesFiles(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).files().addExecutable(SOURCE.file("mvnw"), JHipsterModule.to("mvnw")).addExecutable(SOURCE.file("mvnw.cmd"), JHipsterModule.to("mvnw.cmd")).batch(SOURCE.append(".mvn/wrapper"), JHipsterModule.to(".mvn/wrapper")).addFile("maven-wrapper.jar").addFile("maven-wrapper.properties").and().and();
    }

    private JavaBuildPlugin mavenCompilerPlugin() {
        return JHipsterModule.javaBuildPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-compiler-plugin").versionSlug("compiler-plugin").additionalElements("<configuration>\n  <source>${java.version}</source>\n  <target>${java.version}</target>\n  <compilerArgs>\n    <arg>-parameters</arg>\n  </compilerArgs>\n</configuration>\n").build();
    }

    private JavaBuildPlugin surefirePlugin() {
        return JHipsterModule.javaBuildPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-surefire-plugin").versionSlug("surefire-plugin").additionalElements("<configuration>\n  <!-- Force alphabetical order to have a reproducible build -->\n  <runOrder>alphabetical</runOrder>\n  <excludes>\n    <exclude>**/*IT*</exclude>\n    <exclude>**/*IntTest*</exclude>\n    <exclude>**/*CucumberTest*</exclude>\n  </excludes>\n</configuration>\n").build();
    }

    private JavaBuildPlugin jacocoPlugin() {
        return JHipsterModule.javaBuildPlugin().groupId(JACOCO_GROUP).artifactId(JACOCO_ARTIFACT_ID).versionSlug(JACOCO_VERSION).build();
    }

    private JavaBuildPlugin failsafePlugin() {
        return JHipsterModule.javaBuildPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-failsafe-plugin").versionSlug("failsafe-plugin").additionalElements("<configuration>\n  <!-- Due to spring-boot repackage, without adding this property test classes are not found\n         See https://github.com/spring-projects/spring-boot/issues/6254 -->\n  <classesDirectory>${project.build.outputDirectory}</classesDirectory>\n  <!-- Force alphabetical order to have a reproducible build -->\n  <runOrder>alphabetical</runOrder>\n  <includes>\n    <include>**/*IT*</include>\n    <include>**/*IntTest*</include>\n    <include>**/*CucumberTest*</include>\n  </includes>\n</configuration>\n<executions>\n  <execution>\n    <id>integration-test</id>\n    <goals>\n      <goal>integration-test</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>verify</id>\n    <goals>\n      <goal>verify</goal>\n    </goals>\n  </execution>\n</executions>\n").build();
    }

    private JavaBuildPlugin jacocoPluginManagement() {
        return JHipsterModule.javaBuildPlugin().groupId(JACOCO_GROUP).artifactId(JACOCO_ARTIFACT_ID).versionSlug(JACOCO_VERSION).additionalElements("<executions>\n  <execution>\n    <id>pre-unit-tests</id>\n    <goals>\n      <goal>prepare-agent</goal>\n    </goals>\n  </execution>\n  <!-- Ensures that the code coverage report for unit tests is created after unit tests have been run -->\n  <execution>\n    <id>post-unit-test</id>\n    <phase>test</phase>\n    <goals>\n      <goal>report</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>pre-integration-tests</id>\n    <goals>\n      <goal>prepare-agent-integration</goal>\n    </goals>\n  </execution>\n  <!-- Ensures that the code coverage report for integration tests is created after integration tests have been run -->\n  <execution>\n    <id>post-integration-tests</id>\n    <phase>post-integration-test</phase>\n    <goals>\n      <goal>report-integration</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>merge</id>\n    <phase>verify</phase>\n    <goals>\n      <goal>merge</goal>\n    </goals>\n    <configuration>\n      <fileSets>\n        <fileSet implementation=\"org.apache.maven.shared.model.fileset.FileSet\">\n          <directory>${project.basedir}</directory>\n          <includes>\n            <include>**/*.exec</include>\n          </includes>\n        </fileSet>\n      </fileSets>\n      <destFile>target/jacoco/allTest.exec</destFile>\n    </configuration>\n  </execution>\n  <execution>\n    <id>post-merge-report</id>\n    <phase>verify</phase>\n    <goals>\n      <goal>report</goal>\n    </goals>\n    <configuration>\n      <dataFile>target/jacoco/allTest.exec</dataFile>\n      <outputDirectory>target/jacoco/</outputDirectory>\n    </configuration>\n  </execution>\n</executions>\n").build();
    }

    private JavaBuildPlugin enforcerPluginManagement() {
        return JHipsterModule.javaBuildPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-enforcer-plugin").versionSlug("maven-enforcer-plugin").additionalElements("<executions>\n  <execution>\n    <id>enforce-versions</id>\n    <goals>\n      <goal>enforce</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>enforce-dependencyConvergence</id>\n    <configuration>\n      <rules>\n        <DependencyConvergence />\n      </rules>\n      <fail>false</fail>\n    </configuration>\n    <goals>\n      <goal>enforce</goal>\n    </goals>\n  </execution>\n</executions>\n<configuration>\n  <rules>\n    <requireMavenVersion>\n      <message>You are running an older version of Maven. JHipster requires at least Maven ${maven.version}</message>\n      <version>[${maven.version},)</version>\n    </requireMavenVersion>\n    <requireJavaVersion>\n      <message>You are running an incompatible version of Java. JHipster supports JDK 17.</message>\n      <version>[17,18)</version>\n    </requireJavaVersion>\n  </rules>\n</configuration>\n").build();
    }
}

