/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.broker.pulsar.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class PulsarModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/broker/pulsar");
    private static final String PULSAR_CONFIG = "technical/infrastructure/config/pulsar";
    private static final String DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/pulsar.yml up -d";
    private final DockerImages dockerImages;

    public PulsarModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(packagePath);
        return JHipsterModule.moduleBuilder(properties).context().put("pulsarDockerImage", this.dockerImages.get("apachepulsar/pulsar").fullName()).and().javaDependencies().addDependency(JHipsterModule.groupId("org.apache.pulsar"), JHipsterModule.artifactId("pulsar-client"), JHipsterModule.versionSlug("pulsar")).addDependency(this.testContainerDependency()).and().files().add(SOURCE.template("pulsar.yml"), JHipsterModule.toSrcMainDocker().append("pulsar.yml")).add(SOURCE.template("PulsarTestContainerExtension.java"), testDestination.append("PulsarTestContainerExtension.java")).batch(SOURCE, JHipsterModule.toSrcMainJava().append(packagePath).append(PULSAR_CONFIG)).addTemplate("PulsarProperties.java").addTemplate("PulsarConfiguration.java").and().add(SOURCE.template("PulsarConfigurationIT.java"), testDestination.append(PULSAR_CONFIG).append("PulsarConfigurationIT.java")).and().startupCommand(DOCKER_COMPOSE_COMMAND).springMainProperties().set(JHipsterModule.propertyKey("pulsar.client.service-url"), JHipsterModule.propertyValue("pulsar://localhost:6650")).and().springTestProperties().set(JHipsterModule.propertyKey("pulsar.client.num-io-threads"), JHipsterModule.propertyValue("8")).set(JHipsterModule.propertyKey("pulsar.producer.topic-name"), JHipsterModule.propertyValue("test-topic")).set(JHipsterModule.propertyKey("pulsar.consumer.topic-names[0]"), JHipsterModule.propertyValue("test-topic")).set(JHipsterModule.propertyKey("pulsar.consumer.subscription-name"), JHipsterModule.propertyValue("test-subscription")).and().integrationTestExtension("PulsarTestContainerExtension").build();
    }

    private JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId("pulsar").versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }
}

