/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.mongock.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class MongockModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/dbmigration/mongock");
    private static final GroupId MONGOCK_GROUP = JHipsterModule.groupId("io.mongock");
    private static final String MONGOCK_SECONDARY = "technical/infrastructure/secondary/mongock";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependencyManagement(this.mongockBom()).addDependency(MONGOCK_GROUP, JHipsterModule.artifactId("mongock-springboot")).addDependency(MONGOCK_GROUP, JHipsterModule.artifactId("mongodb-springdata-v4-driver")).and().documentation(JHipsterModule.documentationTitle("Mongock"), SOURCE.append("mongock.md")).files().add(SOURCE.template("MongockDatabaseConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(MONGOCK_SECONDARY).append("MongockDatabaseConfiguration.java")).and().springMainProperties().set(JHipsterModule.propertyKey("mongock.migration-scan-package"), JHipsterModule.propertyValue(properties.basePackage().get())).and().springTestProperties().set(JHipsterModule.propertyKey("mongock.migration-scan-package"), JHipsterModule.propertyValue(properties.basePackage().get())).and().build();
    }

    private JavaDependency mongockBom() {
        return JHipsterModule.javaDependency().groupId(MONGOCK_GROUP).artifactId("mongock-bom").versionSlug("mongock").scope(JavaDependencyScope.IMPORT).type(JavaDependencyType.POM).build();
    }
}

