/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.dummy.liquibase.domain;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;

public class DummyLiquibaseModuleFactory {
    private static final DateTimeFormatter FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/dummy/liquibase");
    private static final JHipsterDestination CHANGELOG_DESTINATION = JHipsterModule.to("src/main/resources/config/liquibase/changelog");
    private static final TextNeedleBeforeReplacer CHANGELOG_NEEDLE = JHipsterModule.lineBeforeText("<!-- jhipster-needle-liquibase-add-changelog -->");

    public JHipsterModule buildModule(JHipsterModuleProperties properties, Instant date) {
        Assert.notNull("properties", properties);
        Assert.notNull("date", date);
        String changelogFilename = this.changelogFilename(date);
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)JHipsterModule.moduleBuilder(properties).files().add(SOURCE.file("00000000000_dummy_feature_schema.xml"), CHANGELOG_DESTINATION.append(changelogFilename)).and().mandatoryReplacements().in(JHipsterModule.path("src/main/resources/config/liquibase/master.xml")).add(CHANGELOG_NEEDLE, this.changelogLine(changelogFilename))).and()).and().build();
    }

    private String changelogFilename(Instant date) {
        return FILE_DATE_FORMAT.format(date) + "_dummy_feature_schema.xml";
    }

    private String changelogLine(String changelogFilename) {
        return "<include file=\"config/liquibase/changelog/" + changelogFilename + "\" relativeToChangelogFile=\"false\"/>";
    }
}

