/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import java.util.ArrayList;
import java.util.Collection;
import tech.jhipster.lite.common.domain.JHipsterCollections;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;

public abstract class JHipsterModuleReplacements {
    private final Collection<ContentReplacer> replacements;

    protected JHipsterModuleReplacements(JHipsterModuleReplacementsBuilder<?, ?> builder) {
        Assert.notNull("builder", builder);
        Assert.notNull("replacements", builder.replacements);
        this.replacements = JHipsterCollections.immutable(builder.replacements);
    }

    public Collection<ContentReplacer> replacements() {
        return this.replacements;
    }

    public static abstract class JHipsterModuleReplacementsBuilder<Replacements extends JHipsterModuleReplacements, FileReplacementsBuilder extends JHipsterModuleFileReplacementsBuilder<?, ?>> {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<ContentReplacer> replacements = new ArrayList<ContentReplacer>();

        protected JHipsterModuleReplacementsBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        void add(ContentReplacer fileReplacer) {
            Assert.notNull("fileReplacer", fileReplacer);
            this.replacements.add(fileReplacer);
        }

        public abstract FileReplacementsBuilder in(JHipsterProjectFilePath var1);

        public abstract Replacements build();
    }

    public static abstract class JHipsterModuleFileReplacementsBuilder<ReplacementsBuilder extends JHipsterModuleReplacementsBuilder<?, ?>, Builder extends JHipsterModuleFileReplacementsBuilder<ReplacementsBuilder, Builder>> {
        private final ReplacementsBuilder replacements;
        private final JHipsterProjectFilePath file;

        protected JHipsterModuleFileReplacementsBuilder(ReplacementsBuilder replacements, JHipsterProjectFilePath file) {
            Assert.notNull("replacements", replacements);
            Assert.notNull("file", file);
            this.replacements = replacements;
            this.file = file;
        }

        public Builder add(ElementReplacer elementToReplace, String replacement) {
            Assert.notNull("elementToReplace", elementToReplace);
            ((JHipsterModuleReplacementsBuilder)this.replacements).add(this.buildReplacer(this.file, elementToReplace, replacement));
            return this.self();
        }

        private Builder self() {
            return (Builder)this;
        }

        public ReplacementsBuilder and() {
            return this.replacements;
        }

        protected abstract ContentReplacer buildReplacer(JHipsterProjectFilePath var1, ElementReplacer var2, String var3);
    }
}

