/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.common.domain.Enums;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencies;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesRepository;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenType;

@Repository
public class FileSystemProjectJavaDependenciesRepository
implements ProjectJavaDependenciesRepository {
    private static final String POM_XML = "pom.xml";

    @Override
    public ProjectJavaDependencies get(JHipsterProjectFolder folder) {
        ProjectJavaDependencies projectJavaDependencies;
        block9: {
            Path pomPath = folder.filePath(POM_XML);
            if (Files.notExists(pomPath, new LinkOption[0])) {
                return ProjectJavaDependencies.EMPTY;
            }
            InputStream input = Files.newInputStream(pomPath, new OpenOption[0]);
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model pomContent = reader.read(input);
                projectJavaDependencies = ProjectJavaDependencies.builder().versions(this.extractVersions(pomContent)).dependenciesManagements(this.extractDependenciesManagement(pomContent)).dependencies(this.extractDependencies(pomContent));
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw GeneratorException.technicalError("Error reading pom file: " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return projectJavaDependencies;
    }

    private ProjectJavaDependenciesVersions extractVersions(Model pomContent) {
        List<JavaDependencyVersion> versions = pomContent.getProperties().entrySet().stream().filter(this.versionProperties()).map(this.toJavaDependencyVersion()).toList();
        return new ProjectJavaDependenciesVersions(versions);
    }

    private Predicate<Map.Entry<Object, Object>> versionProperties() {
        return entry -> entry.getKey().toString().endsWith(".version");
    }

    private Function<Map.Entry<Object, Object>, JavaDependencyVersion> toJavaDependencyVersion() {
        return entry -> new JavaDependencyVersion(entry.getKey().toString(), entry.getValue().toString());
    }

    private JavaDependencies extractDependenciesManagement(Model pomContent) {
        DependencyManagement dependencyManagement = pomContent.getDependencyManagement();
        if (dependencyManagement == null) {
            return JavaDependencies.EMPTY;
        }
        List<JavaDependency> mavenDependencies = dependencyManagement.getDependencies().stream().map(this.toJavaDependency()).toList();
        return new JavaDependencies(mavenDependencies);
    }

    private JavaDependencies extractDependencies(Model pomContent) {
        List<JavaDependency> mavenDependencies = pomContent.getDependencies().stream().map(this.toJavaDependency()).toList();
        return new JavaDependencies(mavenDependencies);
    }

    private Function<Dependency, JavaDependency> toJavaDependency() {
        return dependency -> JavaDependency.builder().groupId(dependency.getGroupId()).artifactId(dependency.getArtifactId()).versionSlug(dependency.getVersion()).classifier(dependency.getClassifier()).optional(dependency.isOptional()).scope(Enums.map(MavenScope.from(dependency.getScope()), JavaDependencyScope.class)).type(MavenType.from(dependency.getType()).map(type -> Enums.map(type, JavaDependencyType.class)).orElse(null)).build();
    }
}

