/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class MicrometerRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with Micrometer";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.MicrometerRules`. [Source](https://error-prone.picnic.tech/refasterrules/MicrometerRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new TagsOf1Recipe(), new TagsOf2Recipe(), new TagsOf3Recipe(), new TagsOf4Recipe(), new TagsOf5Recipe()});
    }

    @NullMarked
    public static class TagsOf1Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf1 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag) {\n        return Refaster.anyOf(ImmutableSet.of(tag), ImmutableList.of(tag));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag) {\n        return Tags.of(tag);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{tag:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{tag:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"io.micrometer.core.instrument.Tags.of(#{tag:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("io.micrometer.core.instrument.Tag", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TagsOf2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf2 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2), ImmutableList.of(tag1, tag2));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2) {\n        return Tags.of(tag1, tag2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("io.micrometer.core.instrument.Tag", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TagsOf3Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf3 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3), ImmutableList.of(tag1, tag2, tag3));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3) {\n        return Tags.of(tag1, tag2, tag3);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("io.micrometer.core.instrument.Tag", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TagsOf4Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf4 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3, Tag tag4) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3, tag4), ImmutableList.of(tag1, tag2, tag3, tag4));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3, Tag tag4) {\n        return Tags.of(tag1, tag2, tag3, tag4);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("io.micrometer.core.instrument.Tag", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TagsOf5Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using `Tags` over other immutable collections";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class TagsOf5 {\n    \n    @BeforeTemplate\n    ImmutableCollection<Tag> before(Tag tag1, Tag tag2, Tag tag3, Tag tag4, Tag tag5) {\n        return Refaster.anyOf(ImmutableSet.of(tag1, tag2, tag3, tag4, tag5), ImmutableList.of(tag1, tag2, tag3, tag4, tag5));\n    }\n    \n    @AfterTemplate\n    Iterable<Tag> after(Tag tag1, Tag tag2, Tag tag3, Tag tag4, Tag tag5) {\n        return Tags.of(tag1, tag2, tag3, tag4, tag5);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("io.micrometer.core.instrument.Tag", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

