/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.regex.Pattern;

@BugPattern(summary="This code should likely use the type's canonical name", link="https://error-prone.picnic.tech/bugpatterns/CanonicalClassNameUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class CanonicalClassNameUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> GET_NAME_INVOCATION = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.receiverOfInvocation((Matcher)Matchers.classLiteral((Matcher)Matchers.anything())), Matchers.instanceMethod().onExactClass(Class.class.getCanonicalName()).named("getName")}));
    private static final Pattern CANONICAL_NAME_USING_TYPES = Pattern.compile("(com\\.google\\.errorprone|tech\\.picnic\\.errorprone)\\..*");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!GET_NAME_INVOCATION.matches((Tree)tree, state) || !CanonicalClassNameUsage.isPassedToCanonicalNameUsingType(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getCanonicalName", (VisitorState)state));
    }

    private static boolean isPassedToCanonicalNameUsingType(VisitorState state) {
        MethodInvocationTree methodInvocation;
        TreePath path = state.getPath().getParentPath();
        while (path.getLeaf() instanceof BinaryTree) {
            path = path.getParentPath();
        }
        Tree tree = path.getLeaf();
        return tree instanceof MethodInvocationTree && CanonicalClassNameUsage.isOwnedByCanonicalNameUsingType(ASTHelpers.getSymbol((MethodInvocationTree)(methodInvocation = (MethodInvocationTree)tree)));
    }

    private static boolean isOwnedByCanonicalNameUsingType(Symbol.MethodSymbol symbol) {
        return CANONICAL_NAME_USING_TYPES.matcher(symbol.owner.getQualifiedName()).matches();
    }
}

