/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Prefer `Class::cast` method reference over equivalent lambda expression", link="https://error-prone.picnic.tech/bugpatterns/ClassCastLambdaUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class ClassCastLambdaUsage
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    private static final long serialVersionUID = 1L;

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        Tree tree2;
        if (tree.getParameters().size() != 1 || !((tree2 = tree.getBody()) instanceof TypeCastTree)) {
            return Description.NO_MATCH;
        }
        TypeCastTree typeCast = (TypeCastTree)tree2;
        Type type = ASTHelpers.getType((Tree)typeCast);
        if (type == null || type.isParameterized() || type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        VariableTree param = (VariableTree)Iterables.getOnlyElement(tree.getParameters());
        if (!ASTHelpers.getSymbol((VariableTree)param).equals(ASTHelpers.getSymbol((Tree)typeCast.getExpression()))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)(SourceCode.treeToString((Tree)typeCast.getType(), (VisitorState)state) + ".class::cast")));
    }
}

