/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.util.Name;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.Flags;

@BugPattern(summary="Constant variables should adhere to the `UPPER_SNAKE_CASE` naming convention", link="https://error-prone.picnic.tech/bugpatterns/ConstantNaming", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class ConstantNaming
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<VariableTree> IS_CONSTANT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.STATIC), Matchers.hasModifier((Modifier)Modifier.FINAL)});
    private static final Matcher<VariableTree> IS_PRIVATE = Matchers.hasModifier((Modifier)Modifier.PRIVATE);
    private static final Pattern SNAKE_CASE = Pattern.compile("([a-z])([A-Z])");
    private static final ImmutableSet<String> DEFAULT_EXEMPTED_NAMES = ImmutableSet.of((Object)"serialVersionUID");
    private static final String ADDITIONAL_EXEMPTED_NAMES_FLAG = "CanonicalConstantNaming:ExemptedNames";
    private final ImmutableSet<String> exemptedNames;

    public ConstantNaming() {
        this(ErrorProneFlags.empty());
    }

    @Inject
    ConstantNaming(ErrorProneFlags flags) {
        this.exemptedNames = Sets.union(DEFAULT_EXEMPTED_NAMES, (Set)Flags.getSet((ErrorProneFlags)flags, (String)ADDITIONAL_EXEMPTED_NAMES_FLAG)).immutableCopy();
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        String variableName = tree.getName().toString();
        if (!IS_CONSTANT.matches((Tree)tree, state) || this.exemptedNames.contains((Object)variableName)) {
            return Description.NO_MATCH;
        }
        String replacement = ConstantNaming.toUpperSnakeCase(variableName);
        if (replacement.equals(variableName)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        if (!IS_PRIVATE.matches((Tree)tree, state)) {
            description.setMessage("%s; consider renaming to '%s', though note that this is not a private constant".formatted(this.message(), replacement));
        } else if (ConstantNaming.isVariableNameInUse(replacement, state)) {
            description.setMessage("%s; consider renaming to '%s', though note that a variable with this name is already declared".formatted(this.message(), replacement));
        } else {
            description.addFix((Fix)SuggestedFixes.renameVariable((VariableTree)tree, (String)replacement, (VisitorState)state));
        }
        return description.build();
    }

    private static String toUpperSnakeCase(String variableName) {
        return SNAKE_CASE.matcher(variableName).replaceAll("$1_$2").toUpperCase(Locale.ROOT);
    }

    private static boolean isVariableNameInUse(final String name, VisitorState state) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitVariable(VariableTree tree, @Nullable Void unused) {
                return ((Name)ASTHelpers.getSymbol((VariableTree)tree).getSimpleName()).contentEquals(name) || (Boolean)super.visitVariable(tree, null) != false;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return Boolean.TRUE.equals(r1) || Boolean.TRUE.equals(r2);
            }
        }.scan(state.getPath().getCompilationUnit(), null));
    }
}

