/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.MoreASTHelpers;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Defer string concatenation to the invoked method", link="https://error-prone.picnic.tech/bugpatterns/FormatStringConcatenation", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class FormatStringConcatenation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> ASSERTJ_FAIL_WITH_THROWABLE_METHOD = Matchers.anyMethod().anyClass().withAnyName().withParameters(String.class.getCanonicalName(), new String[]{Throwable.class.getCanonicalName()});
    private static final Matcher<ExpressionTree> ASSERTJ_FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.AbstractAssert").namedAnyOf(new String[]{"overridingErrorMessage", "withFailMessage"}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.AbstractSoftAssertions").named("fail"), Matchers.not(ASSERTJ_FAIL_WITH_THROWABLE_METHOD)}), Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.AbstractStringAssert").named("isEqualTo"), Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.AbstractThrowableAssert").namedAnyOf(new String[]{"hasMessage", "hasMessageContaining", "hasMessageEndingWith", "hasMessageStartingWith", "hasRootCauseMessage", "hasStackTraceContaining"}), Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.Descriptable").namedAnyOf(new String[]{"as", "describedAs"}), Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.ThrowableAssertAlternative").namedAnyOf(new String[]{"withMessage", "withMessageContaining", "withMessageEndingWith", "withMessageStartingWith", "withStackTraceContaining"}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.WithAssertions").named("fail"), Matchers.not(ASSERTJ_FAIL_WITH_THROWABLE_METHOD)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClassAny(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.BDDAssertions", "org.assertj.core.api.Fail"}).named("fail"), Matchers.not(ASSERTJ_FAIL_WITH_THROWABLE_METHOD)})});
    private static final Matcher<ExpressionTree> GUAVA_FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Preconditions.class.getCanonicalName()).namedAnyOf(new String[]{"checkArgument", "checkNotNull", "checkState"}), Matchers.staticMethod().onClass(Verify.class.getCanonicalName()).named("verify")});
    private static final Matcher<ExpressionTree> JDK_FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(String.class.getCanonicalName()).named("format"), Matchers.instanceMethod().onExactClass(Formatter.class.getCanonicalName()).named("format")});
    private static final Matcher<ExpressionTree> SLF4J_FORMAT_METHOD = Matchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"debug", "error", "info", "trace", "warn"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (FormatStringConcatenation.hasNonConstantStringConcatenationArgument(tree, 0, state)) {
            return this.flagViolation(tree, ASSERTJ_FORMAT_METHOD, 0, "%s", state).or(() -> this.flagViolation(tree, JDK_FORMAT_METHOD, 0, "%s", state)).or(() -> this.flagViolation(tree, SLF4J_FORMAT_METHOD, 0, "{}", state)).orElse(Description.NO_MATCH);
        }
        if (FormatStringConcatenation.hasNonConstantStringConcatenationArgument(tree, 1, state)) {
            return this.flagViolation(tree, GUAVA_FORMAT_METHOD, 1, "%s", state).or(() -> this.flagViolation(tree, JDK_FORMAT_METHOD, 1, "%s", state)).or(() -> this.flagViolation(tree, SLF4J_FORMAT_METHOD, 1, "{}", state)).orElse(Description.NO_MATCH);
        }
        return Description.NO_MATCH;
    }

    private Optional<Description> flagViolation(MethodInvocationTree tree, Matcher<ExpressionTree> matcher, int formatStringParam, String formatSpecifier, VisitorState state) {
        if (!matcher.matches((Tree)tree, state)) {
            return Optional.empty();
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() > formatStringParam + 1) {
            return Optional.of(this.describeMatch(tree));
        }
        ExpressionTree formatStringArg = arguments.get(formatStringParam);
        ReplacementArgumentsConstructor replacementConstructor = new ReplacementArgumentsConstructor(formatSpecifier);
        formatStringArg.accept(replacementConstructor, state);
        return Optional.of(this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)formatStringArg, (String)replacementConstructor.getReplacementArguments(state))));
    }

    private static boolean hasNonConstantStringConcatenationArgument(MethodInvocationTree tree, int argPosition, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() <= argPosition) {
            return false;
        }
        ExpressionTree argument = ASTHelpers.stripParentheses((ExpressionTree)arguments.get(argPosition));
        return argument instanceof BinaryTree && MoreASTHelpers.isStringTyped((Tree)argument, (VisitorState)state) && ASTHelpers.constValue((Tree)argument, String.class) == null;
    }

    private static class ReplacementArgumentsConstructor
    extends SimpleTreeVisitor<Void, VisitorState> {
        private final StringBuilder formatString = new StringBuilder();
        private final List<Tree> formatArguments = new ArrayList<Tree>();
        private final String formatSpecifier;

        ReplacementArgumentsConstructor(String formatSpecifier) {
            this.formatSpecifier = formatSpecifier;
        }

        @Override
        public @Nullable Void visitBinary(BinaryTree tree, VisitorState state) {
            if (tree.getKind() == Tree.Kind.PLUS && MoreASTHelpers.isStringTyped((Tree)tree, (VisitorState)state)) {
                tree.getLeftOperand().accept(this, state);
                tree.getRightOperand().accept(this, state);
            } else {
                this.appendExpression(tree);
            }
            return null;
        }

        @Override
        public @Nullable Void visitParenthesized(ParenthesizedTree tree, VisitorState state) {
            return tree.getExpression().accept(this, state);
        }

        @Override
        protected @Nullable Void defaultAction(Tree tree, VisitorState state) {
            this.appendExpression(tree);
            return null;
        }

        private void appendExpression(Tree tree) {
            if (tree instanceof LiteralTree) {
                LiteralTree literal = (LiteralTree)tree;
                this.formatString.append(literal.getValue());
            } else {
                this.formatString.append(this.formatSpecifier);
                this.formatArguments.add(tree);
            }
        }

        private String getReplacementArguments(VisitorState state) {
            return state.getConstantExpression((Object)this.formatString.toString()) + ", " + this.formatArguments.stream().map(tree -> SourceCode.treeToString((Tree)tree, (VisitorState)state)).collect(Collectors.joining(", "));
        }
    }
}

